/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.SpreadSheetTable;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JScrollPane;

public class TabbedPane
extends BaseTabbedPane {
    private static final long serialVersionUID = -2048229771213837710L;
    public static final String PREFIX_TITLE = "new";

    public SpreadSheetTable getTableAt(int index) {
        SpreadSheetTable result;
        if (index < 0 || index >= this.getTabCount()) {
            return null;
        }
        if (this.getComponentAt(index) instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)this.getComponentAt(index);
            result = (SpreadSheetTable)pane.getViewport().getView();
        } else {
            result = (SpreadSheetTable)this.getComponentAt(index);
        }
        return result;
    }

    public SpreadSheet getSheetAt(int index) {
        SpreadSheet result = null;
        SpreadSheetTable table = this.getTableAt(index);
        if (table == null) {
            return result;
        }
        result = table.getSheet();
        return result;
    }

    public void setNumDecimalsAt(int index, int numDec) {
        this.getTableAt(index).setNumDecimals(numDec);
    }

    public int getNumDecimalsAt(int index) {
        return this.getTableAt(index).getNumDecimals();
    }

    public void setNumDecimals(int numDec) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setNumDecimalsAt(i, numDec);
        }
    }

    public void setNegativeBackgroundAt(int index, Color color) {
        this.getTableAt(index).setNegativeBackground(color);
    }

    public Color getNegativeBackgroundAt(int index) {
        return this.getTableAt(index).getNegativeBackground();
    }

    public void setNegativeBackground(Color color) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setNegativeBackgroundAt(i, color);
        }
    }

    public void setPositiveBackgroundAt(int index, Color color) {
        this.getTableAt(index).setPositiveBackground(color);
    }

    public Color getPositiveBackgroundAt(int index) {
        return this.getTableAt(index).getPositiveBackground();
    }

    public void setPositiveBackground(Color color) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setPositiveBackgroundAt(i, color);
        }
    }

    public SpreadSheetTable getCurrentTable() {
        return this.getTableAt(this.getSelectedIndex());
    }

    public SpreadSheet getCurrentSheet() {
        return this.getSheetAt(this.getSelectedIndex());
    }

    public void addTab(String title, SpreadSheetTable table) {
        this.addTab(title, (Component)new BaseScrollPane((Component)table));
        this.setSelectedIndex(this.getTabCount() - 1);
    }

    public List<String> getTabTitles() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            result.add(this.getTitleAt(i));
        }
        return result;
    }

    public String newTitle() {
        String result;
        HashSet<String> titles = new HashSet<String>(this.getTabTitles());
        int i = 0;
        while (titles.contains(result = PREFIX_TITLE + ++i)) {
        }
        return result;
    }
}

