/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class DownSample
extends AbstractRowFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected int m_NthRow;

    public String globalInfo() {
        return "Returns the indices of every n-th row.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("nth", "nthRow", (Object)1);
    }

    public void setNthRow(int value) {
        this.m_NthRow = value;
        this.reset();
    }

    public int getNthRow() {
        return this.m_NthRow;
    }

    public String nthRowTipText() {
        return "Only every n-th row will be output.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"nthRow", (Object)this.m_NthRow, (String)"nth: ");
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < data.getRowCount(); i += this.m_NthRow) {
            result.add(i);
        }
        return result.toArray();
    }
}

