/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;

public class MultiRowStatistic
extends AbstractRowStatistic {
    private static final long serialVersionUID = 2141252366056112668L;
    protected AbstractRowStatistic[] m_Statistics;

    public String globalInfo() {
        return "Combines the statistics calculated from the specified statistic generators.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistics", (Object)new AbstractRowStatistic[0]);
    }

    public void setStatistics(AbstractRowStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public AbstractRowStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to calculate.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int rowIndex) {
        for (AbstractRowStatistic stat : this.m_Statistics) {
            stat.preVisit(sheet, rowIndex);
        }
    }

    @Override
    protected void doVisit(Row row, int rowIndex) {
        for (AbstractRowStatistic stat : this.m_Statistics) {
            stat.doVisit(row, rowIndex);
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = this.createOutputHeader();
        for (AbstractRowStatistic stat : this.m_Statistics) {
            SpreadSheet sub = stat.postVisit(sheet, rowIndex);
            if (sub == null) continue;
            for (Row row : sub.rows()) {
                result.addRow().assign(row);
            }
        }
        return result;
    }
}

