/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetCollapse;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetCollapseTest
extends AbstractFlowTest {
    public SpreadSheetCollapseTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("collapse.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile3.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("collapse.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile3.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile1.csv"), new TmpFile("dumpfile2.csv"), new TmpFile("dumpfile3.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetCollapseTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/collapse.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            SpreadSheet spreadsheet = new SpreadSheet();
            csvspreadsheetreader.setSpreadSheetType(spreadsheet);
            argOption = (AbstractArgumentOption)csvspreadsheetreader.getOptionManager().findByProperty("missingValue");
            csvspreadsheetreader.setMissingValue((String)argOption.valueOf(""));
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors.add(spreadsheetfilereader);
            Branch branch = new Branch();
            ArrayList<Object> branches = new ArrayList<Object>();
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile1.csv"));
            branches.add(dumpfile);
            Sequence sequence = new Sequence();
            argOption = (AbstractArgumentOption)sequence.getOptionManager().findByProperty("name");
            sequence.setName((String)argOption.valueOf("collapsed"));
            ArrayList<Object> actors2 = new ArrayList<Object>();
            SpreadSheetCollapse spreadsheetcollapse = new SpreadSheetCollapse();
            argOption = (AbstractArgumentOption)spreadsheetcollapse.getOptionManager().findByProperty("separator");
            spreadsheetcollapse.setSeparator((String)argOption.valueOf(" | "));
            actors2.add(spreadsheetcollapse);
            DumpFile dumpfile2 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile2.getOptionManager().findByProperty("outputFile");
            dumpfile2.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile2.csv"));
            actors2.add(dumpfile2);
            sequence.setActors(actors2.toArray(new AbstractActor[0]));
            branches.add(sequence);
            Sequence sequence2 = new Sequence();
            argOption = (AbstractArgumentOption)sequence2.getOptionManager().findByProperty("name");
            sequence2.setName((String)argOption.valueOf("collapsed no dup"));
            ArrayList<Object> actors3 = new ArrayList<Object>();
            SpreadSheetCollapse spreadsheetcollapse2 = new SpreadSheetCollapse();
            argOption = (AbstractArgumentOption)spreadsheetcollapse2.getOptionManager().findByProperty("separator");
            spreadsheetcollapse2.setSeparator((String)argOption.valueOf(" | "));
            spreadsheetcollapse2.setNoDuplicates(true);
            actors3.add(spreadsheetcollapse2);
            DumpFile dumpfile3 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile3.getOptionManager().findByProperty("outputFile");
            dumpfile3.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile3.csv"));
            actors3.add(dumpfile3);
            sequence2.setActors(actors3.toArray(new AbstractActor[0]));
            branches.add(sequence2);
            branch.setBranches(branches.toArray(new AbstractActor[0]));
            argOption = (AbstractArgumentOption)branch.getOptionManager().findByProperty("numThreads");
            branch.setNumThreads(((Integer)argOption.valueOf("1")).intValue());
            actors.add(branch);
            flow.setActors(actors.toArray(new AbstractActor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SpreadSheetCollapseTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetCollapseTest.runTest((Test)SpreadSheetCollapseTest.suite());
    }
}

