/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetDoubleColumnToString;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.test.TmpFile;
import java.io.File;

public class SpreadSheetDoubleColumnToStringTest
extends AbstractConversionTestCase {
    public SpreadSheetDoubleColumnToStringTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("double.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("double.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("double.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetDoubleColumnToStringTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetDoubleColumnToString[] result = new SpreadSheetDoubleColumnToString[3];
        result[0] = new SpreadSheetDoubleColumnToString();
        result[0].setColumn(new Index("2"));
        result[1] = new SpreadSheetDoubleColumnToString();
        result[1].setColumn(new Index("2"));
        result[1].setNumDecimals(3);
        result[2] = new SpreadSheetDoubleColumnToString();
        result[2].setColumn(new Index("2"));
        result[2].setNumDecimals(3);
        result[2].setFixedDecimals(true);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

