/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetStringColumnToDate;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.test.TmpFile;
import java.io.File;

public class SpreadSheetStringColumnToDateTest
extends AbstractConversionTestCase {
    public SpreadSheetStringColumnToDateTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("date.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("date.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("date.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetStringColumnToDateTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetStringColumnToDate[] result = new SpreadSheetStringColumnToDate[2];
        result[0] = new SpreadSheetStringColumnToDate();
        result[0].setColumn(new Index("2"));
        result[0].setFormat(new DateFormatString("dd/MM/yyyy"));
        result[1] = new SpreadSheetStringColumnToDate();
        result[1].setColumn(new Index("3"));
        result[1].setFormat(new DateFormatString("MM/dd/yyyy"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

