/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.data.DecimalFormatString;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetStringColumnToLong;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.test.TmpFile;
import java.io.File;

public class SpreadSheetStringColumnToLongTest
extends AbstractConversionTestCase {
    public SpreadSheetStringColumnToLongTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("long.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("long.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("long.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetStringColumnToLongTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetStringColumnToLong[] result = new SpreadSheetStringColumnToLong[2];
        result[0] = new SpreadSheetStringColumnToLong();
        result[0].setColumn(new Index("2"));
        result[0].setFormat(new DecimalFormatString("#"));
        result[1] = new SpreadSheetStringColumnToLong();
        result[1].setColumn(new Index("3"));
        result[1].setFormat(new DecimalFormatString("#,###"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

