/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractCellFinderTestCase
extends AdamsTestCase {
    public AbstractCellFinderTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/cellfinder/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractCellFinder[] getRegressionSetups();

    protected CellLocation[] process(SpreadSheet data, AbstractCellFinder scheme) {
        Iterator iter = scheme.findCells(data);
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result.toArray(new CellLocation[result.size()]);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    protected boolean save(CellLocation[] data, String filename) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < data.length; ++i) {
            list.add(data[i].toString());
        }
        return FileUtils.saveToFile(list, (File)new TmpFile(filename));
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractCellFinder[] setups = this.getRegressionSetups();
        AbstractCellFinderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractCellFinderTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractCellFinder current = (AbstractCellFinder)setups[i].shallowCopy();
            AbstractCellFinderTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            CellLocation[] processed = this.process(data, current);
            AbstractCellFinderTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractCellFinderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractCellFinderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

