/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Range;
import adams.core.RangeTest;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetColumnRangeTest
extends RangeTest {
    protected SpreadSheet m_Sheet;

    public SpreadSheetColumnRangeTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/core/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "simple.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        if (this.m_Sheet == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("simple.csv");
        super.tearDown();
    }

    protected Range newRange(String index, int max) {
        if (index == null) {
            return new SpreadSheetColumnRange();
        }
        return new SpreadSheetColumnRange(index, max);
    }

    public void testColumnNames() {
        SpreadSheetColumnRange range = new SpreadSheetColumnRange();
        range = new SpreadSheetColumnRange("first-last");
        SpreadSheetColumnRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"first-last", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("blah");
        SpreadSheetColumnRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"blah", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Field");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"Field", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("field");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"Field", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Feild");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be empty", (String)"", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("Field-Value");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"Field-Value", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Field-Value");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"Field-Value", (String)range.getRange());
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[1]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices()[2]);
    }

    public void testSpecialColumnNames() {
        SpreadSheetColumnRange range = new SpreadSheetColumnRange();
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Hyphen-ated\"");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"\"Hyphen-ated\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Com,ma\"");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)4, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"\"Com,ma\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Hyphen-ated\",\"Com,ma\"");
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices()[0]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be valid", (int)4, (int)range.getIntIndices()[1]);
        SpreadSheetColumnRangeTest.assertEquals((String)"should be same", (String)"\"Hyphen-ated\",\"Com,ma\"", (String)range.getRange());
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetColumnRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetColumnRangeTest.runTest((Test)SpreadSheetColumnRangeTest.suite());
    }
}

