/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.SpreadSheetUtils;
import adams.test.AdamsTestCase;

public class SpreadSheetUtilsTest
extends AdamsTestCase {
    public SpreadSheetUtilsTest(String name) {
        super(name);
    }

    protected void compare(String[] expected, String[] generated) {
        SpreadSheetUtilsTest.assertNotNull((String)"shouldn't be null", (Object)generated);
        SpreadSheetUtilsTest.assertEquals((String)"number of elements differ", (int)expected.length, (int)generated.length);
        for (int i = 0; i < expected.length; ++i) {
            SpreadSheetUtilsTest.assertEquals((String)"elements differ", (String)expected[i], (String)generated[i]);
        }
    }

    public void testSplit() {
        String s = "A,B,C";
        this.compare(new String[]{"A", "B", "C"}, SpreadSheetUtils.split((String)s, (char)','));
        s = "A,B,C";
        this.compare(new String[]{"A,B,C"}, SpreadSheetUtils.split((String)s, (char)'-'));
        s = "A,\"B,D\",C";
        this.compare(new String[]{"A", "\"B,D\"", "C"}, SpreadSheetUtils.split((String)s, (char)','));
        s = "A-B-C";
        this.compare(new String[]{"A", "B", "C"}, SpreadSheetUtils.split((String)s, (char)'-'));
        s = "A-\"B-D\"-C";
        this.compare(new String[]{"A", "\"B-D\"", "C"}, SpreadSheetUtils.split((String)s, (char)'-'));
    }
}

