/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SequencePlotter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import adams.flow.transformer.plotgenerator.SimplePlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;
import adams.gui.visualization.sequence.XYSequenceDotPaintlet;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetPlotGeneratorTest
extends AbstractFlowTest {
    public SpreadSheetPlotGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.csv")});
        SpreadSheetFileReader ssr = new SpreadSheetFileReader();
        SpreadSheetPlotGenerator plot1 = new SpreadSheetPlotGenerator();
        SimplePlotGenerator simple = new SimplePlotGenerator();
        simple.setPlotColumns("first,last");
        plot1.setGenerator((AbstractPlotGenerator)simple);
        SequencePlotter sp1 = new SequencePlotter();
        sp1.setPaintlet((XYSequencePaintlet)new XYSequenceLinePaintlet());
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{plot1, sp1});
        SpreadSheetPlotGenerator plot2 = new SpreadSheetPlotGenerator();
        simple = new SimplePlotGenerator();
        simple.setPlotColumns("first,last");
        plot2.setGenerator((AbstractPlotGenerator)simple);
        SequencePlotter sp2 = new SequencePlotter();
        sp2.setPaintlet((XYSequencePaintlet)new XYSequenceLinePaintlet());
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{plot2, sp2});
        SpreadSheetPlotGenerator plot3 = new SpreadSheetPlotGenerator();
        XYPlotGenerator generator = new XYPlotGenerator();
        generator.setPlotColumns("last_1,last");
        generator.setXColumn("last");
        plot3.setGenerator((AbstractPlotGenerator)generator);
        SequencePlotter sp3 = new SequencePlotter();
        XYSequenceDotPaintlet dot = new XYSequenceDotPaintlet();
        dot.setStrokeThickness(3.0f);
        sp3.setPaintlet((XYSequencePaintlet)dot);
        Sequence seq3 = new Sequence();
        seq3.setActors(new AbstractActor[]{plot3, sp3});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{seq1, seq2, seq3});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, ssr, br});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetPlotGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetPlotGeneratorTest.runTest((Test)SpreadSheetPlotGeneratorTest.suite());
    }
}

