/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.ConvertSpreadSheetRows;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.SpreadSheet;
import adams.test.TmpFile;
import java.io.File;

public class ConvertSpreadSheetRowsTest
extends AbstractConversionTestCase {
    public ConvertSpreadSheetRowsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("sparse.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("sparse.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("sparse.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            ConvertSpreadSheetRowsTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        ConvertSpreadSheetRows[] result = new ConvertSpreadSheetRows[]{new ConvertSpreadSheetRows(), new ConvertSpreadSheetRows()};
        result[1].setDataRowType(DataRowType.SPARSE);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

