/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.FileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetGetCell;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetGetCellTest
extends AbstractFlowTest {
    public SpreadSheetGetCellTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        DumpFile df = new DumpFile();
        df.setName("out");
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{df});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("iris.csv")});
        SpreadSheetFileReader ssr = new SpreadSheetFileReader();
        SpreadSheetGetCell ssc1 = new SpreadSheetGetCell();
        ssc1.setRow(new Range("1"));
        ssc1.setColumn(new SpreadSheetColumnRange("1"));
        GlobalSink gs1 = new GlobalSink();
        gs1.setGlobalName(new GlobalActorReference("out"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{ssc1, gs1});
        SpreadSheetGetCell ssc2 = new SpreadSheetGetCell();
        ssc2.setRow(new Range("2"));
        ssc2.setColumn(new SpreadSheetColumnRange("2"));
        GlobalSink gs2 = new GlobalSink();
        gs2.setGlobalName(new GlobalActorReference("out"));
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{ssc2, gs2});
        SpreadSheetGetCell ssc3 = new SpreadSheetGetCell();
        ssc3.setRow(new Range("3"));
        ssc3.setColumn(new SpreadSheetColumnRange("3"));
        GlobalSink gs3 = new GlobalSink();
        gs3.setGlobalName(new GlobalActorReference("out"));
        Sequence seq3 = new Sequence();
        seq3.setActors(new AbstractActor[]{ssc3, gs3});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{seq1, seq2, seq3});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, ssr, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetGetCellTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetGetCellTest.runTest((Test)SpreadSheetGetCellTest.suite());
    }
}

