/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.base.BaseString;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.AbstractSymbolEvaluatorTestCase;
import adams.parser.SpreadSheetQuery;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetQueryTest
extends AbstractSymbolEvaluatorTestCase<Double, SpreadSheetQuery> {
    protected SpreadSheet m_Sheet;

    public SpreadSheetQueryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        this.m_TestHelper.deleteFileFromTmp(filename);
    }

    protected BaseString[][][] getRegressionSymbols() {
        return new BaseString[][][]{{new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0], new BaseString[0]}};
    }

    protected String[][] getRegressionExpressions() {
        return new String[][]{{"SELECT duration", "SELECT duration as dur", "SELECT duration ORDER by class", "SELECT duration,wage-increase-first-year,wage-increase-second-year,wage-increase-third-year,cost-of-living-adjustment WHERE (duration >= 2)", "SELECT duration as dur,wage-increase-first-year as wfy,wage-increase-second-year,wage-increase-third-year,cost-of-living-adjustment WHERE ((duration >= 2) or (working-hours < 40) or (working-hours < 38)) and not (bereavement-assistance regexp \"^yes$\") ORDER by class", "UPDATE SET duration = 3.5", "UPDATE SET duration = 3.5 WHERE (duration >= 2)", "UPDATE SET duration = 3.5 WHERE ((duration >= 2) or (working-hours < 40) or (working-hours < 38)) and not (bereavement-assistance regexp \"^yes$\")", "DELETE WHERE (duration >= 2)", "DELETE WHERE ((duration >= 2) or (working-hours < 40) or (working-hours < 38)) and not (bereavement-assistance regexp \"^yes$\")", "SELECT duration LIMIT 2", "SELECT duration LIMIT 10,2", "SELECT duration WHERE bereavement-assistance = \"yes\""}};
    }

    protected Object[] process(String[] expressions, BaseString[][] symbols, SpreadSheetQuery scheme) {
        scheme.setSheet(this.m_Sheet);
        return super.process(expressions, symbols, (AbstractSymbolEvaluator)scheme);
    }

    protected SpreadSheetQuery[] getRegressionSetups() {
        return new SpreadSheetQuery[]{new SpreadSheetQuery()};
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetQueryTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetQueryTest.runTest((Test)SpreadSheetQueryTest.suite());
    }
}

