/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetLongColumnToDouble;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.test.TmpFile;
import java.io.File;

public class SpreadSheetLongColumnToDoubleTest
extends AbstractConversionTestCase {
    public SpreadSheetLongColumnToDoubleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("long.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("long.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("long.csv");
        try {
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            reader.setTextColumns(new Range("first-last"));
            result = new SpreadSheet[]{reader.read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetLongColumnToDoubleTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetLongColumnToDouble[] result = new SpreadSheetLongColumnToDouble[]{new SpreadSheetLongColumnToDouble(), new SpreadSheetLongColumnToDouble()};
        result[1].setColumn(new SpreadSheetColumnIndex("2"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

