/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.DoubleMatrixToSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.test.TmpFile;
import java.io.File;

public class DoubleMatrixToSpreadSheetTest
extends AbstractConversionTestCase {
    public DoubleMatrixToSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Double[][][] result;
        TmpFile file = new TmpFile("bolts.csv");
        try {
            SpreadSheet data = new CsvSpreadSheetReader().read((File)file);
            result = new Double[1][data.getRowCount()][data.getColumnCount()];
            for (int i = 0; i < data.getRowCount(); ++i) {
                DataRow row = data.getRow(i);
                for (int n = 0; n < data.getColumnCount(); ++n) {
                    result[0][i][n] = row.getCell(n).toDouble();
                }
            }
        }
        catch (Exception e) {
            result = new Double[][][]{};
            DoubleMatrixToSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        DoubleMatrixToSpreadSheet[] result = new DoubleMatrixToSpreadSheet[]{new DoubleMatrixToSpreadSheet()};
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

