/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetAddRowID;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.test.TmpFile;
import java.io.File;

public class SpreadSheetAddRowIDTest
extends AbstractConversionTestCase {
    public SpreadSheetAddRowIDTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("bolts.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetAddRowIDTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetAddRowID[] result = new SpreadSheetAddRowID[6];
        result[0] = new SpreadSheetAddRowID();
        result[1] = new SpreadSheetAddRowID();
        result[1].setHeader("Funky");
        result[2] = new SpreadSheetAddRowID();
        result[2].setPosition(new SpreadSheetColumnIndex("last"));
        result[3] = new SpreadSheetAddRowID();
        result[3].setPosition(new SpreadSheetColumnIndex("last"));
        result[3].setAfter(true);
        result[4] = new SpreadSheetAddRowID();
        result[4].setPosition(new SpreadSheetColumnIndex("TOTAL"));
        result[4].setAfter(true);
        result[5] = new SpreadSheetAddRowID();
        result[5].setStart(100);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

