/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.AggregateSpreadSheet;
import adams.data.conversion.Conversion;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.env.Environment;
import adams.flow.transformer.SpreadSheetAggregate;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AggregateSpreadSheetTest
extends AbstractConversionTestCase {
    public AggregateSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("bolts.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            AggregateSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        AggregateSpreadSheet[] result = new AggregateSpreadSheet[]{new AggregateSpreadSheet(), new AggregateSpreadSheet()};
        result[1].setKeyColumns(new SpreadSheetColumnRange("2"));
        result[1].setAggregates(new SpreadSheetAggregate.Aggregate[]{SpreadSheetAggregate.Aggregate.AVERAGE, SpreadSheetAggregate.Aggregate.STDEV});
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(AggregateSpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AggregateSpreadSheetTest.runTest((Test)AggregateSpreadSheetTest.suite());
    }
}

