/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetBinarize;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetBinarizeTest
extends AbstractConversionTestCase {
    public SpreadSheetBinarizeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("iris.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetBinarizeTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetBinarize[] result = new SpreadSheetBinarize[3];
        result[0] = new SpreadSheetBinarize();
        result[1] = new SpreadSheetBinarize();
        result[1].setColumns(new SpreadSheetColumnRange("2-3"));
        result[2] = new SpreadSheetBinarize();
        result[2].setColumns(new SpreadSheetColumnRange("last"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetBinarizeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetBinarizeTest.runTest((Test)SpreadSheetBinarizeTest.suite());
    }
}

