/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetStringColumnToBoolean;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetStringColumnToBooleanTest
extends AbstractConversionTestCase {
    public SpreadSheetStringColumnToBooleanTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("boolean.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("boolean.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("boolean.csv");
        try {
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            reader.setTextColumns(new Range("first-last"));
            result = new SpreadSheet[]{reader.read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetStringColumnToBooleanTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetStringColumnToBoolean[] result = new SpreadSheetStringColumnToBoolean[2];
        result[0] = new SpreadSheetStringColumnToBoolean();
        result[0].setColumn(new SpreadSheetColumnIndex("2"));
        result[0].setValueTrue("true");
        result[1] = new SpreadSheetStringColumnToBoolean();
        result[1].setColumn(new SpreadSheetColumnIndex("3"));
        result[1].setValueTrue("T");
        result[1].setCaseInsensitive(true);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetStringColumnToBooleanTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetStringColumnToBooleanTest.runTest((Test)SpreadSheetStringColumnToBooleanTest.suite());
    }
}

