/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringMatrixToSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringMatrixToSpreadSheetTest
extends AbstractConversionTestCase {
    public StringMatrixToSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        String[][][] result;
        TmpFile file = new TmpFile("labor.csv");
        try {
            SpreadSheet data = new CsvSpreadSheetReader().read((File)file);
            result = new String[2][data.getRowCount()][data.getColumnCount()];
            for (int i = 0; i < data.getRowCount(); ++i) {
                DataRow row = data.getRow(i);
                for (int n = 0; n < data.getColumnCount(); ++n) {
                    result[0][i][n] = row.getCell(n).getContent();
                    result[1][i][n] = row.getCell(n).getContent();
                }
            }
        }
        catch (Exception e) {
            result = new String[][][]{};
            StringMatrixToSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        StringMatrixToSpreadSheet[] result = new StringMatrixToSpreadSheet[]{new StringMatrixToSpreadSheet(), new StringMatrixToSpreadSheet()};
        result[1].setForceString(true);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(StringMatrixToSpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringMatrixToSpreadSheetTest.runTest((Test)StringMatrixToSpreadSheetTest.suite());
    }
}

