/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.colstatistic;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractColumnStatistic;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractColumnStatisticTestCase
extends AdamsTestCase {
    public AbstractColumnStatisticTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/colstatistic/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractColumnStatistic[] getRegressionSetups();

    protected abstract int[] getRegressionColumns();

    protected SpreadSheet process(SpreadSheet data, int column, AbstractColumnStatistic scheme) {
        return scheme.generate(data, column);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    protected boolean save(SpreadSheet data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data);
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractColumnStatistic[] setups = this.getRegressionSetups();
        int[] columns = this.getRegressionColumns();
        AbstractColumnStatisticTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        AbstractColumnStatisticTestCase.assertEquals((String)"Number of setups and columns differ!", (int)setups.length, (int)columns.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractColumnStatisticTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractColumnStatistic current = (AbstractColumnStatistic)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractColumnStatisticTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            SpreadSheet processed = this.process(data, columns[i], current);
            AbstractColumnStatisticTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractColumnStatisticTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractColumnStatisticTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

