/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import java.io.File;
import java.util.HashMap;

public class LookUpHelper {
    public static HashMap<String, Object> load(PlaceholderFile file, String key, String value, boolean useNative, StringBuilder error) {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setMissingValue("");
        SpreadSheet sheet = reader.read((File)file);
        return LookUpHelper.load(sheet, key, value, useNative, error);
    }

    public static HashMap<String, Object> load(SpreadSheet sheet, String key, String value, boolean useNative, StringBuilder error) {
        int keyCol = -1;
        int valCol = -1;
        if (sheet.getColumnCount() < 2) {
            error.append("Spreadsheet must have at least 2 columns, available: " + sheet.getColumnCount());
            return null;
        }
        SpreadSheetColumnIndex m_KeyColumn = new SpreadSheetColumnIndex(key);
        m_KeyColumn.setSpreadSheet(sheet);
        keyCol = m_KeyColumn.getIntIndex();
        if (keyCol == -1) {
            error.append("Failed to locate key column: " + m_KeyColumn.getIndex());
            return null;
        }
        SpreadSheetColumnIndex m_ValueColumn = new SpreadSheetColumnIndex(value);
        m_ValueColumn.setSpreadSheet(sheet);
        valCol = m_ValueColumn.getIntIndex();
        if (valCol == -1) {
            error.append("Failed to locate value column: " + m_ValueColumn.getIndex());
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Row row : sheet.rows()) {
            if (!row.hasCell(keyCol) || row.getCell(keyCol).isMissing() || !row.hasCell(valCol) || row.getCell(valCol).isMissing()) continue;
            String k = row.getCell(keyCol).getContent();
            Object v = useNative ? row.getCell(valCol).getNative() : row.getCell(valCol).getContent();
            if (k == null || v == null) continue;
            result.put(k, v);
        }
        return result;
    }
}

