/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SpreadSheetAggregate
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 444466366407383727L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected SpreadSheetColumnRange m_AggregateColumns;
    protected Aggregate[] m_Aggregates;

    public String globalInfo() {
        return "Aggregates rows (min, max, avg, etc) in a spreadsheet using key columns.\nAll numeric columns in the specified aggregrate range (excluding the key columns) get aggregated. For each of the specified aggregates a new column is generated.\nIf no key column(s) provided, the complete spreadsheet is used for aggregation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("aggregate-columns", "aggregateColumns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("aggregate", "aggregates", (Object)new Aggregate[]{Aggregate.SUM});
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets; if left empty, all rows are used.";
    }

    public void setAggregateColumns(SpreadSheetColumnRange value) {
        this.m_AggregateColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAggregateColumns() {
        return this.m_AggregateColumns;
    }

    public String aggregateColumnsTipText() {
        return "The columns to aggregate (only numeric ones will be used).";
    }

    public void setAggregates(Aggregate[] value) {
        this.m_Aggregates = value;
        this.reset();
    }

    public Aggregate[] getAggregates() {
        return this.m_Aggregates;
    }

    public String aggregatesTipText() {
        return "The aggregates to calculate and introduce as columns.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"aggregateColumns", (Object)((Object)this.m_AggregateColumns), (String)"cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumns", (Object)(this.m_KeyColumns.isEmpty() ? "-none-" : this.m_KeyColumns), (String)", key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"aggregates", (Object)this.m_Aggregates, (String)", agg: ");
        return result;
    }

    protected HashMap<Aggregate, Number> computeAggregates(SpreadSheet input, List<Integer> subset, int index) {
        double[] values;
        Cell cell;
        int i;
        HashMap<Aggregate, Number> result = new HashMap<Aggregate, Number>();
        for (Aggregate agg : this.m_Aggregates) {
            result.put(agg, Double.NaN);
        }
        TDoubleArrayList list = new TDoubleArrayList();
        if (subset != null) {
            for (i = 0; i < subset.size(); ++i) {
                cell = input.getCell(subset.get(i).intValue(), index);
                if (cell == null || !cell.isNumeric()) continue;
                list.add(cell.toDouble().doubleValue());
            }
        } else {
            for (i = 0; i < input.getRowCount(); ++i) {
                cell = input.getCell(i, index);
                if (cell == null || !cell.isNumeric()) continue;
                list.add(cell.toDouble().doubleValue());
            }
        }
        if ((values = list.toArray()).length > 0) {
            block14: for (Aggregate agg : this.m_Aggregates) {
                switch (agg) {
                    case COUNT: {
                        result.put(agg, values.length);
                        continue block14;
                    }
                    case SUM: {
                        result.put(agg, StatUtils.sum((double[])values));
                        continue block14;
                    }
                    case MIN: {
                        result.put(agg, StatUtils.min((double[])values));
                        continue block14;
                    }
                    case MAX: {
                        result.put(agg, StatUtils.max((double[])values));
                        continue block14;
                    }
                    case AVERAGE: {
                        result.put(agg, StatUtils.mean((double[])values));
                        continue block14;
                    }
                    case MEDIAN: {
                        result.put(agg, StatUtils.median((double[])values));
                        continue block14;
                    }
                    case STDEV: {
                        result.put(agg, StatUtils.stddev((double[])values, (boolean)true));
                        continue block14;
                    }
                    case STDEVP: {
                        result.put(agg, StatUtils.stddev((double[])values, (boolean)false));
                        continue block14;
                    }
                    case INTERQUARTILE: {
                        result.put(agg, StatUtils.iqr((double[])values));
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled aggregate: " + (Object)((Object)agg));
                    }
                }
            }
        }
        return result;
    }

    protected String doExecute() {
        RowIdentifier rows;
        int[] keys;
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet aggregated = null;
        if (!this.m_KeyColumns.isEmpty()) {
            this.m_KeyColumns.setSpreadSheet(input);
            keys = this.m_KeyColumns.getIntIndices();
            if (keys.length == 0) {
                result = "No key columns defined!";
            }
            rows = new RowIdentifier((Range)this.m_KeyColumns);
        } else {
            keys = new int[]{};
            rows = null;
        }
        if (result == null) {
            this.m_AggregateColumns.setSpreadSheet(input);
            int[] agg = this.m_AggregateColumns.getIntIndices();
            TIntHashSet numeric = new TIntHashSet();
            for (int index : agg) {
                if (keys.length > 0 && this.m_KeyColumns.isInRange(index) || !input.isNumeric(index, true)) continue;
                numeric.add(index);
            }
            agg = numeric.toArray();
            Arrays.sort(agg);
            if (rows != null) {
                rows.identify(input);
            }
            aggregated = input.newInstance();
            aggregated.setDataRowClass(input.getDataRowClass());
            HeaderRow row = aggregated.getHeaderRow();
            for (int index : keys) {
                row.addCell("" + index).setContent(input.getHeaderRow().getCell(index).getContent());
            }
            for (int index : agg) {
                for (Aggregate a : this.m_Aggregates) {
                    row.addCell("" + index + "-" + (Object)((Object)a)).setContent(input.getHeaderRow().getCell(index).getContent() + "-" + (Object)((Object)a));
                }
            }
            if (rows != null) {
                for (String key : rows.getKeys()) {
                    DataRow rowNew = aggregated.addRow();
                    List subset = rows.getRows(key);
                    for (int index : keys) {
                        rowNew.addCell("" + index).setContent(input.getRow(((Integer)subset.get(0)).intValue()).getCell(index).getContent());
                    }
                    for (int index : agg) {
                        HashMap<Aggregate, Number> aggs = this.computeAggregates(input, subset, index);
                        for (Aggregate a : this.m_Aggregates) {
                            if (aggs.get(agg) instanceof Integer) {
                                rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Integer)aggs.get((Object)a));
                                continue;
                            }
                            if (aggs.get(agg) instanceof Long) {
                                rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Long)aggs.get((Object)a));
                                continue;
                            }
                            rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent(Double.valueOf(aggs.get((Object)a).doubleValue()));
                        }
                    }
                }
            } else {
                DataRow rowNew = aggregated.addRow();
                for (int index : keys) {
                    rowNew.addCell("" + index).setContent(input.getRow(0).getCell(index).getContent());
                }
                for (int index : agg) {
                    HashMap<Aggregate, Number> aggs = this.computeAggregates(input, null, index);
                    for (Aggregate a : this.m_Aggregates) {
                        if (aggs.get(agg) instanceof Integer) {
                            rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Integer)aggs.get((Object)a));
                            continue;
                        }
                        if (aggs.get(agg) instanceof Long) {
                            rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Long)aggs.get((Object)a));
                            continue;
                        }
                        rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent(Double.valueOf(aggs.get((Object)a).doubleValue()));
                    }
                }
            }
        }
        if (aggregated != null) {
            this.m_OutputToken = new Token(aggregated);
        }
        return result;
    }

    public static enum Aggregate {
        COUNT,
        SUM,
        MIN,
        MAX,
        AVERAGE,
        MEDIAN,
        STDEV,
        STDEVP,
        INTERQUARTILE;

    }
}

