/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.StringObjectHandler;

public class SpreadSheetStringColumnToObject
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 3105708418230954318L;
    protected AbstractObjectHandler m_Handler;

    public String globalInfo() {
        return "Converts the specified spreadsheet column from string to an object, using the specified handler.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new StringObjectHandler());
    }

    @Override
    public String columnTipText() {
        return "The column to convert to an object; " + this.m_Column.getExample();
    }

    public void setHandler(AbstractObjectHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractObjectHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler for parsing the strings in the cells and turning them into an object.";
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        String content = cellOld.getContent();
        cellNew.setObject(this.m_Handler.parse(content));
    }
}

