/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.management.LocaleHelper;
import adams.data.io.output.AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;

public abstract class AbstractMultiSheetFormattedSpreadSheetWriter
extends AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport {
    private static final long serialVersionUID = 7265152337280890568L;
    protected Locale m_Locale;
    protected String m_NumberFormat;
    protected transient NumberFormat m_Formatter;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locale", "locale", (Object)LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("number-format", "numberFormat", (Object)this.getDefaultNumberFormat());
    }

    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String localeTipText() {
        return "The locale to use for formatting the numbers.";
    }

    protected String getDefaultNumberFormat() {
        return "";
    }

    public void setNumberFormat(String value) {
        this.m_NumberFormat = value;
        this.reset();
    }

    public String getNumberFormat() {
        return this.m_NumberFormat;
    }

    public String numberFormatTipText() {
        return "The format for the numbers (see java.text.DecimalFormat), use empty string for default 'double' output.";
    }

    protected synchronized String format(double value) {
        String result;
        if (this.m_NumberFormat.length() > 0) {
            if (this.m_Formatter == null) {
                try {
                    this.m_Formatter = LocaleHelper.getSingleton().getNumberFormat(this.m_Locale);
                    ((DecimalFormat)this.m_Formatter).applyPattern(this.m_NumberFormat);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to initialize formatter with format '" + this.m_NumberFormat + "':", e);
                    this.m_Formatter = LocaleHelper.getSingleton().getNumberFormat(this.m_Locale);
                }
            }
            result = this.m_Formatter.format(value);
        } else {
            result = Utils.doubleToString((double)value, (int)12, (Locale)this.m_Locale);
        }
        return result;
    }
}

