/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUpRemove
extends AbstractTransformer {
    private static final long serialVersionUID = 5163954885888948620L;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Removes a key/value pair from the specified lookup table. The string passing through is interpreted as the key to remove.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            String key;
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            if (lookup.containsKey(key = (String)this.m_InputToken.getPayload())) {
                lookup.remove(key);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Removed: '" + key + "'");
                }
            } else {
                this.getLogger().warning("Key '" + key + "' not available from lookup table '" + this.m_StorageName + "', not removed!");
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }
}

