/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.MultiSheetSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.ToolBarPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.TabVisibilityChangeEvent;
import adams.gui.event.TabVisibilityChangeListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.spreadsheetviewer.AbstractDataPlugin;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.TabbedPane;
import adams.gui.tools.spreadsheetviewer.menu.DataChart;
import adams.gui.tools.spreadsheetviewer.menu.DataComputeDifference;
import adams.gui.tools.spreadsheetviewer.menu.DataConvert;
import adams.gui.tools.spreadsheetviewer.menu.DataFilterColumns;
import adams.gui.tools.spreadsheetviewer.menu.DataFilterRows;
import adams.gui.tools.spreadsheetviewer.menu.DataSort;
import adams.gui.tools.spreadsheetviewer.menu.DataTransform;
import adams.gui.tools.spreadsheetviewer.menu.FileCloseTab;
import adams.gui.tools.spreadsheetviewer.menu.FileExit;
import adams.gui.tools.spreadsheetviewer.menu.FileOpen;
import adams.gui.tools.spreadsheetviewer.menu.FileSave;
import adams.gui.tools.spreadsheetviewer.menu.FileSaveAs;
import adams.gui.tools.spreadsheetviewer.menu.HelpFormulas;
import adams.gui.tools.spreadsheetviewer.menu.HelpQuery;
import adams.gui.tools.spreadsheetviewer.menu.SpreadSheetViewerAction;
import adams.gui.tools.spreadsheetviewer.menu.ViewApplyToAll;
import adams.gui.tools.spreadsheetviewer.menu.ViewDecimals;
import adams.gui.tools.spreadsheetviewer.menu.ViewNegativeBackground;
import adams.gui.tools.spreadsheetviewer.menu.ViewPositiveBackground;
import adams.gui.tools.spreadsheetviewer.menu.ViewShowFormulas;
import adams.gui.tools.spreadsheetviewer.tab.ViewerTabManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class SpreadSheetViewerPanel
extends ToolBarPanel
implements MenuBarProvider,
SendToActionSupporter,
CleanUpHandler {
    private static final long serialVersionUID = -7759194648757624838L;
    public static final String FILENAME = "SpreadSheetViewer.props";
    public static final String FILENAME_MENU = "SpreadSheetViewerMenu.props";
    public static final String SESSION_FILE = "SpreadSheetViewerSession.props";
    protected static Properties m_Properties;
    protected static Properties m_PropertiesMenu;
    protected BaseSplitPane m_SplitPane;
    protected TabbedPane m_TabbedPane;
    protected ViewerTabManager m_ViewerTabs;
    protected JMenuBar m_MenuBar;
    protected SpreadSheetViewerAction m_ActionFileOpen;
    protected JMenu m_MenuFileOpenRecent;
    protected SpreadSheetViewerAction m_ActionFileSave;
    protected SpreadSheetViewerAction m_ActionFileSaveAs;
    protected SpreadSheetViewerAction m_ActionFileCloseTab;
    protected SpreadSheetViewerAction m_ActionFileExit;
    protected SpreadSheetViewerAction m_ActionDataFilterColumns;
    protected SpreadSheetViewerAction m_ActionDataFilterRows;
    protected SpreadSheetViewerAction m_ActionDataComputeDifference;
    protected SpreadSheetViewerAction m_ActionDataConvert;
    protected SpreadSheetViewerAction m_ActionDataTransform;
    protected SpreadSheetViewerAction m_ActionDataSort;
    protected SpreadSheetViewerAction m_ActionDataChart;
    protected SpreadSheetViewerAction m_ActionViewApplyToAll;
    protected SpreadSheetViewerAction m_ActionViewDisplayedDecimals;
    protected SpreadSheetViewerAction m_ActionViewNegativeBackground;
    protected SpreadSheetViewerAction m_ActionViewPositiveBackground;
    protected SpreadSheetViewerAction m_ActionViewShowFormulas;
    protected SpreadSheetViewerAction m_ActionHelpFormulas;
    protected SpreadSheetViewerAction m_MenuItemHelpQuery;
    protected List<JMenuItem> m_MenuItemDataPlugins;
    protected List<AbstractDataPlugin> m_DataPlugins;
    protected List<JMenuItem> m_MenuItemViewPlugins;
    protected List<AbstractViewPlugin> m_ViewPlugins;
    protected SpreadSheetFileChooser m_FileChooser;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;
    protected boolean m_ApplyToAll;
    protected List<SpreadSheetViewerAction> m_Actions;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_RecentFilesHandler = null;
        this.m_ApplyToAll = false;
        this.m_Actions = new ArrayList<SpreadSheetViewerAction>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.setToolBarLocation(ToolBarPanel.ToolBarLocation.NORTH);
        this.m_SplitPane = new BaseSplitPane(1, true);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_TabbedPane = new TabbedPane(this);
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.m_SplitPane.setLeftComponent((Component)((Object)this.m_TabbedPane));
        this.m_ViewerTabs = new ViewerTabManager(this);
        this.m_ViewerTabs.addTabVisibilityChangeListener(new TabVisibilityChangeListener(){

            public void tabVisibilityChanged(TabVisibilityChangeEvent e) {
                SpreadSheetViewerPanel.this.m_SplitPane.setRightComponentHidden(SpreadSheetViewerPanel.this.m_ViewerTabs.getTabCount() == 0);
            }
        });
        this.m_SplitPane.setRightComponent((Component)((Object)this.m_ViewerTabs));
        this.m_SplitPane.setRightComponentHidden(this.m_ViewerTabs.getTabCount() == 0);
        this.m_SplitPane.setDividerLocation(0.8);
    }

    protected void initActions() {
        SpreadSheetViewerAction action = new FileOpen();
        this.m_ActionFileOpen = action;
        this.m_Actions.add(action);
        action = new FileSave();
        this.m_ActionFileSave = action;
        this.m_Actions.add(action);
        action = new FileSaveAs();
        this.m_ActionFileSaveAs = action;
        this.m_Actions.add(action);
        action = new FileCloseTab();
        this.m_ActionFileCloseTab = action;
        this.m_Actions.add(action);
        action = new FileExit();
        this.m_ActionFileExit = action;
        this.m_Actions.add(action);
        action = new DataFilterColumns();
        this.m_ActionDataFilterColumns = action;
        this.m_Actions.add(action);
        action = new DataFilterRows();
        this.m_ActionDataFilterRows = action;
        this.m_Actions.add(action);
        action = new DataConvert();
        this.m_ActionDataConvert = action;
        this.m_Actions.add(action);
        action = new DataTransform();
        this.m_ActionDataTransform = action;
        this.m_Actions.add(action);
        action = new DataSort();
        this.m_ActionDataSort = action;
        this.m_Actions.add(action);
        action = new DataChart();
        this.m_ActionDataChart = action;
        this.m_Actions.add(action);
        action = new DataComputeDifference();
        this.m_ActionDataComputeDifference = action;
        this.m_Actions.add(action);
        action = new ViewApplyToAll();
        this.m_ActionViewApplyToAll = action;
        this.m_Actions.add(action);
        action = new ViewDecimals();
        this.m_ActionViewDisplayedDecimals = action;
        this.m_Actions.add(action);
        action = new ViewNegativeBackground();
        this.m_ActionViewNegativeBackground = action;
        this.m_Actions.add(action);
        action = new ViewPositiveBackground();
        this.m_ActionViewPositiveBackground = action;
        this.m_Actions.add(action);
        action = new ViewShowFormulas();
        this.m_ActionViewShowFormulas = action;
        this.m_Actions.add(action);
        action = new HelpFormulas();
        this.m_ActionHelpFormulas = action;
        this.m_Actions.add(action);
        action = new HelpQuery();
        this.m_MenuItemHelpQuery = action;
        this.m_Actions.add(action);
    }

    protected void initToolBar() {
        this.addToToolBar((Action)((Object)this.m_ActionFileOpen));
        this.addToToolBar((Action)((Object)this.m_ActionFileSave));
        this.addSeparator();
        this.addToToolBar((Action)((Object)this.m_ActionDataFilterColumns));
        this.addToToolBar((Action)((Object)this.m_ActionDataFilterRows));
        this.addToToolBar((Action)((Object)this.m_ActionDataConvert));
        this.addToToolBar((Action)((Object)this.m_ActionDataTransform));
        this.addToToolBar((Action)((Object)this.m_ActionDataSort));
        this.addToToolBar((Action)((Object)this.m_ActionDataChart));
        this.addSeparator();
        this.addToToolBar((Action)((Object)this.m_ActionViewDisplayedDecimals));
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            JMenuItem menuitem;
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SpreadSheetViewerPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SpreadSheetViewerPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menu.add((Action)((Object)this.m_ActionFileOpen));
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, SpreadSheetViewerPanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    SpreadSheetViewerPanel.this.load((SpreadSheetReader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler(), ((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile());
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuFileOpenRecent = submenu;
            menu.add((Action)((Object)this.m_ActionFileSave));
            menu.add((Action)((Object)this.m_ActionFileSaveAs));
            menu.add((Action)((Object)this.m_ActionFileCloseTab));
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menu.add((Action)((Object)this.m_ActionFileExit));
            menu = new JMenu("Data");
            result.add(menu);
            menu.setMnemonic('D');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menu.add((Action)((Object)this.m_ActionDataFilterColumns));
            menu.add((Action)((Object)this.m_ActionDataFilterRows));
            menu.add((Action)((Object)this.m_ActionDataConvert));
            menu.add((Action)((Object)this.m_ActionDataTransform));
            menu.add((Action)((Object)this.m_ActionDataSort));
            menu.add((Action)((Object)this.m_ActionDataChart));
            menu.add((Action)((Object)this.m_ActionDataComputeDifference));
            String[] classes = AbstractDataPlugin.getPlugins();
            if (classes.length > 0) {
                menu.addSeparator();
                this.m_MenuItemDataPlugins = new ArrayList<JMenuItem>();
                this.m_DataPlugins = new ArrayList<AbstractDataPlugin>();
                for (String cls : classes) {
                    try {
                        final AbstractDataPlugin data = (AbstractDataPlugin)((Object)Class.forName(cls).newInstance());
                        this.m_DataPlugins.add(data);
                        menuitem = data.getMenuIcon() == null ? new JMenuItem(data.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(data.getMenuText(), GUIHelper.getIcon((String)data.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.process(data);
                            }
                        });
                        this.m_MenuItemDataPlugins.add(menuitem);
                        menu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for data plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menu.add(this.m_ActionViewApplyToAll.getMenuItem());
            menu.add((Action)((Object)this.m_ActionViewDisplayedDecimals));
            menu.add((Action)((Object)this.m_ActionViewNegativeBackground));
            menu.add((Action)((Object)this.m_ActionViewPositiveBackground));
            menu.add(this.m_ActionViewShowFormulas.getMenuItem());
            this.m_ViewerTabs.addTabsSubmenu(menu);
            classes = AbstractViewPlugin.getPlugins();
            if (classes.length > 0) {
                menu.addSeparator();
                this.m_MenuItemViewPlugins = new ArrayList<JMenuItem>();
                this.m_ViewPlugins = new ArrayList<AbstractViewPlugin>();
                for (String cls : classes) {
                    try {
                        final AbstractViewPlugin view = (AbstractViewPlugin)((Object)Class.forName(cls).newInstance());
                        this.m_ViewPlugins.add(view);
                        menuitem = view.getMenuIcon() == null ? new JMenuItem(view.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(view.getMenuText(), GUIHelper.getIcon((String)view.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.view(view);
                            }
                        });
                        this.m_MenuItemViewPlugins.add(menuitem);
                        menu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for view plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            menu = new JMenu("Help");
            result.add(menu);
            menu.setMnemonic('H');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menu.add((Action)((Object)this.m_ActionHelpFormulas));
            menu.add((Action)((Object)this.m_MenuItemHelpQuery));
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public TabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public ViewerTabManager getViewerTabs() {
        return this.m_ViewerTabs;
    }

    public void enterNumDecimals(boolean applyAll) {
        int decimals = applyAll ? -1 : this.m_TabbedPane.getNumDecimalsAt(this.m_TabbedPane.getSelectedIndex());
        String valueStr = GUIHelper.showInputDialog((Component)((Object)this), (String)"Please enter the number of decimals to display (-1 to display all):", (String)("" + decimals));
        if (valueStr == null) {
            return;
        }
        decimals = Integer.parseInt(valueStr);
        if (applyAll) {
            this.m_TabbedPane.setNumDecimals(decimals);
        } else {
            this.m_TabbedPane.setNumDecimalsAt(this.m_TabbedPane.getSelectedIndex(), decimals);
        }
    }

    public void selectBackground(boolean negative, boolean applyAll) {
        Color color = applyAll ? Color.WHITE : (negative ? this.m_TabbedPane.getNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex()) : this.m_TabbedPane.getPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex()));
        color = negative ? JColorChooser.showDialog((Component)((Object)this), "Background for negative values", color) : JColorChooser.showDialog((Component)((Object)this), "Background for positive values", color);
        if (color == null) {
            return;
        }
        if (negative) {
            if (applyAll) {
                this.m_TabbedPane.setNegativeBackground(color);
            } else {
                this.m_TabbedPane.setNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
            }
        } else if (applyAll) {
            this.m_TabbedPane.setPositiveBackground(color);
        } else {
            this.m_TabbedPane.setPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
        }
    }

    protected void updateActions() {
        for (SpreadSheetViewerAction action : this.m_Actions) {
            action.update((Object)this);
        }
    }

    public void updateMenu() {
        int i;
        if (this.m_MenuBar == null) {
            return;
        }
        boolean sheetSelected = this.m_TabbedPane.getTabCount() > 0 && this.m_TabbedPane.getSelectedIndex() != -1;
        SpreadSheetPanel panel = this.m_TabbedPane.getCurrentPanel();
        this.updateActions();
        if (this.m_MenuItemDataPlugins != null) {
            for (i = 0; i < this.m_DataPlugins.size(); ++i) {
                this.m_MenuItemDataPlugins.get(i).setEnabled(sheetSelected && this.m_DataPlugins.get(i).canProcess(panel));
            }
        }
        if (this.m_MenuItemViewPlugins != null) {
            for (i = 0; i < this.m_ViewPlugins.size(); ++i) {
                this.m_MenuItemViewPlugins.get(i).setEnabled(sheetSelected && this.m_ViewPlugins.get(i).canView(panel));
            }
        }
    }

    public boolean checkForModified() {
        boolean result;
        if (this.getCurrentPanel() == null) {
            return true;
        }
        boolean bl = result = !this.getCurrentPanel().isModified();
        if (!result) {
            String msg = this.getCurrentPanel().getFilename() == null ? "Spreadsheet not saved - save?" : "Spreadsheet not saved - save?\n" + this.getCurrentPanel().getFilename();
            int retVal = GUIHelper.showConfirmMessage((Component)((Object)this), (String)msg, (String)"Spreadsheet not saved");
            switch (retVal) {
                case 0: {
                    if (this.getCurrentPanel().getFilename() != null) {
                        this.save();
                    } else {
                        this.saveAs();
                    }
                    result = !this.getCurrentPanel().isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void open() {
        PlaceholderFile[] files;
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : files = this.m_FileChooser.getSelectedPlaceholderFiles()) {
            this.load((SpreadSheetReader)this.m_FileChooser.getReader(), (File)file);
        }
    }

    public void load(File file) {
        this.load(this.m_FileChooser.getReaderForFile(file), file);
    }

    public void load(SpreadSheetReader reader, File file) {
        if (reader == null) {
            reader = new CsvSpreadSheetReader();
        }
        SpreadSheet sheet = null;
        List sheets = null;
        if (reader instanceof MultiSheetSpreadSheetReader) {
            sheets = ((MultiSheetSpreadSheetReader)reader).readRange(file.getAbsolutePath());
        } else {
            sheet = reader.read(file.getAbsolutePath());
        }
        if (sheet == null && sheets == null) {
            String msg = reader.hasLastError() ? "Error loading spreadsheet file:\n" + file + "\n" + reader.getLastError() : "Error loading spreadsheet file:\n" + file;
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
        } else {
            if (sheet != null) {
                SpreadSheetPanel panel = this.m_TabbedPane.addTab(file, sheet);
                panel.setReader(reader);
            } else {
                for (SpreadSheet sh : sheets) {
                    SpreadSheetPanel panel = this.m_TabbedPane.addTab(file, sh);
                    panel.setReader(reader);
                }
            }
            this.m_FileChooser.setCurrentDirectory(file.getParentFile());
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
            }
        }
    }

    public void write(SpreadSheetWriter writer, File file) {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        SpreadSheetPanel panel = this.m_TabbedPane.getPanelAt(index);
        if (panel == null) {
            return;
        }
        SpreadSheetTable table = panel.getTable();
        if (table == null) {
            return;
        }
        SpreadSheet sheet = table.toSpreadSheet();
        writer.reset();
        if (!writer.write(sheet, file)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write spreadsheet to '" + file + "'!"));
        } else {
            panel.setFilename(file);
            panel.setWriter(writer);
            panel.setModified(false);
            this.m_TabbedPane.setTitleAt(index, this.m_TabbedPane.createTabTitle(file, sheet));
            this.updateMenu();
        }
    }

    public void save() {
        SpreadSheetPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (panel.getFilename() == null) {
            this.saveAs();
            return;
        }
        if (panel.getReader() == null) {
            this.saveAs();
            return;
        }
        if (panel.getWriter() == null) {
            if (panel.getReader().getCorrespondingWriter() == null) {
                this.saveAs();
                return;
            }
            this.write(panel.getReader().getCorrespondingWriter(), panel.getFilename());
        } else {
            this.write(panel.getWriter(), this.getCurrentPanel().getFilename());
        }
    }

    public void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        this.write((SpreadSheetWriter)this.m_FileChooser.getWriter(), (File)file);
        if (this.m_RecentFilesHandler != null && ((SpreadSheetWriter)this.m_FileChooser.getWriter()).getCorrespondingReader() != null) {
            this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup((File)file, (Object)((SpreadSheetWriter)this.m_FileChooser.getWriter()).getCorrespondingReader()));
        }
    }

    public void closeFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (!this.checkForModified()) {
            return;
        }
        this.m_TabbedPane.remove(index);
    }

    public void close() {
        if (!this.checkForModified()) {
            this.setVisibleAgain();
            return;
        }
        this.closeParent();
    }

    public SpreadSheetPanel[] getAllPanels() {
        return this.m_TabbedPane.getAllPanels();
    }

    public SpreadSheetPanel getCurrentPanel() {
        return this.m_TabbedPane.getCurrentPanel();
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{PlaceholderFile.class, JTable.class}, (Class[])cls) && this.m_TabbedPane.getSelectedIndex() != -1;
    }

    public Object getSendToItem(Class[] cls) {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        SpreadSheetTable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            SpreadSheet sheet = this.m_TabbedPane.getTableAt(index).toSpreadSheet();
            if (!writer.write(sheet, (File)((PlaceholderFile)(result = SendToActionUtils.nextTmpFile((String)"spreadsheetviewer", (String)"csv"))))) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_TabbedPane.getTableAt(index);
        }
        return result;
    }

    public void filterData(String oldTitle, Object input, AbstractActor filter) {
        try {
            List processed = ActorUtils.transform((AbstractActor)filter, (Object)input);
            for (Object obj : processed) {
                if (!(obj instanceof SpreadSheet)) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Generated non-spreadsheet object??\n" + obj.getClass().getName()));
                    return;
                }
                this.m_TabbedPane.addTab(oldTitle + "'", (SpreadSheet)obj);
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to filter data:\n" + Utils.throwableToString((Throwable)e)));
        }
    }

    protected void process(AbstractDataPlugin plugin) {
        SpreadSheetPanel panel = this.m_TabbedPane.getCurrentPanel();
        if (panel == null) {
            return;
        }
        SpreadSheet input = panel.getSheet();
        if (input == null) {
            return;
        }
        plugin.setCurrentPanel(panel);
        SpreadSheet output = plugin.process(input);
        if (plugin.getCanceledByUser() || output == null) {
            return;
        }
        if (plugin.isInPlace()) {
            this.m_TabbedPane.getCurrentTable().setModel((TableModel)new SpreadSheetTableModel(output));
        } else {
            this.m_TabbedPane.addTab(this.m_TabbedPane.newTitle(), output);
        }
        plugin.setCurrentPanel(null);
    }

    protected void view(final AbstractViewPlugin plugin) {
        SpreadSheetPanel current = this.m_TabbedPane.getCurrentPanel();
        if (current == null || current.getSheet() == null) {
            return;
        }
        SpreadSheet sheet = current.getSheet();
        plugin.setCurrentPanel(current);
        BasePanel panel = plugin.generate(sheet);
        if (plugin.getCanceledByUser() || panel == null) {
            plugin.setCurrentPanel(null);
            return;
        }
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(this.getParentFrame(), false);
        String title = plugin.getMenuText();
        if (current.getTabTitle() != null) {
            title = title + " - " + current.getTabTitle();
        }
        dialog.setTitle(title);
        if (plugin.getMenuIcon() != null) {
            dialog.setIconImage(GUIHelper.getIcon((String)plugin.getMenuIcon()).getImage());
        }
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setCancelVisible(plugin.requiresButtons());
        dialog.setApproveVisible(plugin.requiresButtons());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                plugin.setCurrentPanel(null);
            }
        });
        dialog.setVisible(true);
    }

    protected void setVisibleAgain() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(true);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(true);
        }
    }

    public void cleanUp() {
        if (this.m_Actions != null) {
            for (SpreadSheetViewerAction action : this.m_Actions) {
                action.cleanUp();
            }
            this.m_Actions = null;
        }
    }

    public void setApplyToAll(boolean value) {
        this.m_ApplyToAll = value;
    }

    public boolean getApplyToAll() {
        return this.m_ApplyToAll;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read((String)"adams/gui/tools/SpreadSheetViewer.props");
            }
            catch (Exception e) {
                m_Properties = new Properties();
                System.err.println("Failed to load properties: SpreadSheetViewer.props");
                e.printStackTrace();
            }
        }
        return m_Properties;
    }

    public static synchronized Properties getPropertiesMenu() {
        if (m_PropertiesMenu == null) {
            try {
                m_PropertiesMenu = Properties.read((String)"adams/gui/tools/SpreadSheetViewerMenu.props");
            }
            catch (Exception e) {
                m_PropertiesMenu = new Properties();
                System.err.println("Failed to load properties: SpreadSheetViewerMenu.props");
                e.printStackTrace();
            }
        }
        return m_PropertiesMenu;
    }
}

