/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GnumericSpreadSheetReaderTest.java
 * Copyright (C) 2016 University of Waikato, Hamilton, New Zealand
 */

package adams.data.io.input;

import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Tests the adams.data.io.input.GnumericSpreadSheetReader class. Run from commandline with: <br><br>
 * java adams.data.io.input.GnumericSpreadSheetReader
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 13356 $
 */
public class GnumericSpreadSheetReaderTest
  extends AbstractSpreadSheetReaderTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public GnumericSpreadSheetReaderTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  @Override
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"sample2.gnumeric",
	"sample2.xml",
	"sample2.gnumeric",
	"sample2.xml",
	"sample2.gnumeric",
	"sample2.xml",
	"sample2.gnumeric",
	"sample2.xml",
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  @Override
  protected SpreadSheetReader[] getRegressionSetups() {
    GnumericSpreadSheetReader[]	result;

    result    = new GnumericSpreadSheetReader[8];
    
    result[0] = new GnumericSpreadSheetReader();

    result[1] = new GnumericSpreadSheetReader();
    result[1].setUncompressedInput(true);

    result[2] = new GnumericSpreadSheetReader();
    result[2].setNoHeader(true);

    result[3] = new GnumericSpreadSheetReader();
    result[3].setUncompressedInput(true);
    result[3].setNoHeader(true);

    result[4] = new GnumericSpreadSheetReader();
    result[4].setFirstRow(3);
    result[4].setNumRows(3);

    result[5] = new GnumericSpreadSheetReader();
    result[5].setUncompressedInput(true);
    result[5].setFirstRow(3);
    result[5].setNumRows(3);

    result[6] = new GnumericSpreadSheetReader();
    result[6].setNoHeader(true);
    result[6].setFirstRow(3);
    result[6].setNumRows(3);

    result[7] = new GnumericSpreadSheetReader();
    result[7].setUncompressedInput(true);
    result[7].setNoHeader(true);
    result[7].setFirstRow(3);
    result[7].setNumRows(3);

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(GnumericSpreadSheetReaderTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
