/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.base.AbstractBaseObjectTestCase;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.parser.SpreadSheetQueryText;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetQueryTextTest
extends AbstractBaseObjectTestCase<SpreadSheetQueryText> {
    protected SpreadSheet m_Sheet;

    public SpreadSheetQueryTextTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/parser/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        this.m_TestHelper.deleteFileFromTmp(filename);
    }

    protected SpreadSheetQueryText getDefault() {
        return new SpreadSheetQueryText();
    }

    protected SpreadSheetQueryText getCustom(String s) {
        return new SpreadSheetQueryText(s);
    }

    protected String getTypicalValue() {
        return "SELECT duration,class WHERE duration > 1";
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetQueryTextTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetQueryTextTest.runTest((Test)SpreadSheetQueryTextTest.suite());
    }
}

