/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateFormat;
import adams.core.DateTimeMsec;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetStringColumnToDateTimeMsec
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 8681800940519018023L;
    protected DateFormatString m_Format;
    protected transient DateFormat m_Formatter;

    public String globalInfo() {
        return "Converts the specified spreadsheet column from string to date/time/msec, according to the provided format.\nFor more information on the format, see Javadoc of 'java.text.SimpleDateFormat' class:\nhttp://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", (Object)new DateFormatString("dd/MM/yyyy HH:mm:ss.SSS"));
    }

    @Override
    public String columnTipText() {
        return "The column to convert to date/time/msec; " + this.m_Column.getExample();
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format string used for parsing the strings.";
    }

    @Override
    protected void preConvert(SpreadSheet input) {
        super.preConvert(input);
        this.m_Formatter = this.m_Format.toDateFormat();
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        String content = cellOld.getContent();
        if (content.trim().length() > 0 && this.m_Formatter.check(content.trim())) {
            cellNew.setContent(new DateTimeMsec(this.m_Formatter.parse(content.trim())));
        } else {
            cellNew.setMissing();
        }
    }
}

