/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class SpreadSheetToJson
extends AbstractConversion {
    private static final long serialVersionUID = 4890225060389916155L;

    public String globalInfo() {
        return "Turns a spreadsheet into a JSON array. Missing values get omitted.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return JSONAware.class;
    }

    protected Object doConvert() throws Exception {
        JSONArray result = new JSONArray();
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        HeaderRow header = sheet.getHeaderRow();
        for (Row row : sheet.rows()) {
            JSONObject data = new JSONObject();
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (!row.hasCell(i) || row.getCell(i).isMissing()) continue;
                data.put((Object)header.getCell(i).getContent(), (Object)row.getCell(i).getContent());
            }
            result.add((Object)data);
        }
        return result;
    }
}

