/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.base.BaseDateTime;
import adams.core.net.HtmlUtils;
import adams.data.io.input.GnumericSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class GnumericSpreadSheetWriter
extends AbstractMultiSheetSpreadSheetWriterWithMissingValueSupport {
    private static final long serialVersionUID = -3549185519778801930L;
    public static final String VERSION_MAJOR = "1";
    public static final String VERSION_MINOR = "10";
    public static final String VERSION_REVISION = "13";
    public static final String VERSION = "1.10.13";
    public static final String VALUETYPE_NUMERIC = "40";
    public static final String VALUETYPE_STRING = "60";
    protected BaseDateTime m_CreationTimestamp;
    protected boolean m_UncompressedOutput;

    public String globalInfo() {
        return "Writes Gnumeric workbook files (GZIP compressed or uncompressed XML), version 1.10.13.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("creation-timestamp", "creationTimestamp", (Object)new BaseDateTime("NOW"));
        this.m_OptionManager.add("uncompressed", "uncompressedOutput", (Object)false);
    }

    public void setCreationTimestamp(BaseDateTime value) {
        this.m_CreationTimestamp = value;
        this.reset();
    }

    public BaseDateTime getCreationTimestamp() {
        return this.m_CreationTimestamp;
    }

    public String creationTimestampTipText() {
        return "The timestamp to use as creation date/time info in the file.";
    }

    public void setUncompressedOutput(boolean value) {
        this.m_UncompressedOutput = value;
        this.reset();
    }

    public boolean getUncompressedOutput() {
        return this.m_UncompressedOutput;
    }

    public String uncompressedOutputTipText() {
        return "If enabled, uncompressed XML instead of GZIP compressed output is generated.";
    }

    public String getFormatDescription() {
        return "Gnumeric (XML files)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"gnumeric"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new GnumericSpreadSheetReader();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.STREAM;
    }

    protected long getBound(SpreadSheet content, boolean cols) {
        long result;
        long factor;
        long current = cols ? (long)content.getColumnCount() : (long)content.getRowCount();
        for (result = factor = 256L; result < current; result *= factor) {
        }
        return result;
    }

    @Override
    protected boolean doWrite(SpreadSheet[] content, OutputStream out) {
        boolean result = true;
        try {
            String name;
            PrintStream stream;
            GZIPOutputStream gzip;
            if (this.m_UncompressedOutput) {
                gzip = null;
                stream = new PrintStream(out);
            } else {
                gzip = new GZIPOutputStream(out);
                stream = new PrintStream(gzip);
            }
            DateFormat dformat = new DateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            stream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stream.println("<gnm:Workbook xmlns:gnm=\"http://www.gnumeric.org/v10.dtd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.gnumeric.org/v9.xsd\">");
            stream.println("  <gnm:Version Epoch=\"1\" Major=\"10\" Minor=\"13\" Full=\"1.10.13\"/>");
            stream.println("  <office:document-meta xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" office:version=\"1.1\">");
            stream.println("    <office:meta>");
            stream.println("      <meta:creation-date>" + dformat.format(this.m_CreationTimestamp.dateValue()) + "</meta:creation-date>");
            stream.println("    </office:meta>");
            stream.println("  </office:document-meta>");
            stream.println("  <gnm:SheetNameIndex>");
            int count = 0;
            for (SpreadSheet cont : content) {
                name = this.m_SheetPrefix + ++count;
                stream.println("    <gnm:SheetName gnm:Cols=\"" + this.getBound(cont, true) + "\" gnm:Rows=\"" + this.getBound(cont, false) + "\">" + HtmlUtils.toHTML((String)name) + "</gnm:SheetName>");
            }
            stream.println("  </gnm:SheetNameIndex>");
            stream.println("  <gnm:Sheets>");
            count = 0;
            for (SpreadSheet cont : content) {
                Cell cell;
                int i;
                name = this.m_SheetPrefix + ++count;
                stream.println("    <gnm:Sheet>");
                stream.println("      <gnm:Name>" + HtmlUtils.toHTML((String)name) + "</gnm:Name>");
                stream.println("      <gnm:MaxCol>" + cont.getColumnCount() + "</gnm:MaxCol>");
                stream.println("      <gnm:MaxRow>" + cont.getRowCount() + "</gnm:MaxRow>");
                stream.println("      <gnm:Cells>");
                for (i = 0; i < cont.getColumnCount(); ++i) {
                    cell = cont.getHeaderRow().getCell(i);
                    stream.print("        <gnm:Cell Row=\"0\" Col=\"" + i + "\" ValueType=\"" + VALUETYPE_STRING + "\">");
                    if (cell.isMissing()) {
                        stream.print(Utils.doubleQuote((String)this.m_MissingValue));
                    } else {
                        stream.print(Utils.doubleQuote((String)cell.getContent()));
                    }
                    stream.println("</gnm:Cell>");
                }
                for (int n = 0; n < cont.getRowCount(); ++n) {
                    DataRow row = cont.getRow(n);
                    for (i = 0; i < cont.getColumnCount(); ++i) {
                        String value;
                        boolean numeric;
                        cell = row.getCell(i);
                        if (cell == null || cell.getContent() == null || cell.getContent().length() == 0 || cell.isMissing()) {
                            if (this.m_MissingValue.length() == 0) continue;
                            numeric = false;
                            value = HtmlUtils.toHTML((String)this.m_MissingValue);
                        } else {
                            numeric = cell.isNumeric();
                            value = numeric ? "" + cell.toDouble() : HtmlUtils.toHTML((String)cell.getContent());
                        }
                        String type = numeric ? VALUETYPE_NUMERIC : VALUETYPE_STRING;
                        stream.print("        <gnm:Cell Row=\"" + (n + 1) + "\" Col=\"" + i + "\" ValueType=\"" + type + "\">");
                        stream.print(value);
                        stream.println("</gnm:Cell>");
                    }
                }
                stream.println("      </gnm:Cells>");
                stream.println("    </gnm:Sheet>");
            }
            stream.println("  </gnm:Sheets>");
            stream.println("</gnm:Workbook>");
            stream.flush();
            if (!this.m_UncompressedOutput) {
                gzip.finish();
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }
}

