/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.util.Hashtable;
import java.util.Map;

public class SpreadSheetHelper
extends SpreadSheetUtils {
    public static SpreadSheet append(SpreadSheet first, SpreadSheet second, boolean noCopy) {
        int i;
        if (!noCopy) {
            first = first.getClone();
        }
        HeaderRow headerFirst = first.getHeaderRow();
        HeaderRow headerSecond = second.getHeaderRow();
        Hashtable<String, Integer> headerIndex = new Hashtable<String, Integer>();
        for (i = 0; i < headerFirst.getCellCount(); ++i) {
            headerIndex.put(headerFirst.getCell(i).getContent(), i);
        }
        for (i = 0; i < headerSecond.getCellCount(); ++i) {
            String key = headerSecond.getCell(i).getContent();
            if (headerIndex.containsKey(key)) continue;
            headerFirst.addCell("" + headerFirst.getCellCount()).setContent(key);
            headerIndex.put(key, headerFirst.getCellCount() - 1);
        }
        for (int n = 0; n < second.getRowCount(); ++n) {
            DataRow row = second.getRow(n);
            DataRow newRow = first.addRow();
            for (i = 0; i < headerSecond.getCellCount(); ++i) {
                Integer index = (Integer)headerIndex.get(headerSecond.getCell(i).getContent());
                if (index == null || !row.hasCell(headerSecond.getCellKey(i))) continue;
                newRow.addCell(headerFirst.getCellKey(index.intValue())).assign(row.getCell(headerSecond.getCellKey(i)));
            }
        }
        return first;
    }

    protected static String compareCells(Cell first, Cell second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return "First cell is missing";
        }
        if (second == null) {
            return "Second cell is missing";
        }
        if (first.isMissing() && second.isMissing()) {
            return null;
        }
        if (first.isMissing()) {
            return "First cell is missing";
        }
        if (second.isMissing()) {
            return "Second cell is missing";
        }
        if (!first.getContent().equals(second.getContent())) {
            return "Cells differs: '" + first.getContent() + "' != '" + second.getContent() + "'";
        }
        return null;
    }

    public static String compare(SpreadSheet first, SpreadSheet second) {
        String msg;
        int x;
        if (first.getColumnCount() != second.getColumnCount()) {
            return "Different number of columns: " + first.getColumnCount() + " != " + second.getColumnCount();
        }
        if (first.getRowCount() != second.getRowCount()) {
            return "Different number of rows: " + first.getRowCount() + " != " + second.getRowCount();
        }
        for (x = 0; x < first.getColumnCount(); ++x) {
            msg = SpreadSheetHelper.compareCells(first.getHeaderRow().getCell(x), second.getHeaderRow().getCell(x));
            if (msg == null) continue;
            return "Header differs at #" + (x + 1) + ": " + msg;
        }
        for (int y = 0; y < first.getRowCount(); ++y) {
            for (x = 0; x < first.getColumnCount(); ++x) {
                msg = SpreadSheetHelper.compareCells(first.getHeaderRow().getCell(x), second.getHeaderRow().getCell(x));
                if (msg == null) continue;
                return "Data differs at row " + (y + 1) + "/col " + (x + 1) + ": " + msg;
            }
        }
        return null;
    }

    public static SpreadSheet mapToSpreadSheet(Map map, String[] header) {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        if (header == null || header.length != 2) {
            header = new String[]{"Key", "Value"};
        }
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContentAsString(header[0]);
        row.addCell("V").setContentAsString(header[1]);
        for (Object key : map.keySet()) {
            row = result.addRow();
            row.addCell("K").setContentAsString("" + key);
            row.addCell("V").setNative(map.get(key));
        }
        return result;
    }
}

