/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import adams.data.spreadsheet.columnfinder.ByIndex;
import adams.data.spreadsheet.columnfinder.ByName;
import adams.data.spreadsheet.columnfinder.ColumnFinder;

public class FilteredColumnFinder
extends AbstractColumnFinder {
    private static final long serialVersionUID = 2477340443897443265L;
    protected ColumnFinder m_Filter;
    protected ColumnFinder m_Finder;

    public String globalInfo() {
        return "Applies the 'filter' column-finder first to the data before applying the actual 'finder'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new ByIndex());
        this.m_OptionManager.add("finder", "Finder", (Object)new ByName());
    }

    public void setFilter(ColumnFinder value) {
        this.m_Filter = value;
        this.reset();
    }

    public ColumnFinder getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The column finder to filter the data with first.";
    }

    public void setFinder(ColumnFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ColumnFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The column finder to use on the filtered data.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filder", (Object)this.m_Filter, (String)"filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)", finder: ");
        return result;
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        int[] filteredIndices = this.m_Filter.findColumns(data);
        SpreadSheet filteredData = AbstractColumnFinder.filter(data, filteredIndices);
        int[] found = this.m_Finder.findColumns(filteredData);
        int[] result = new int[found.length];
        for (int i = 0; i < found.length; ++i) {
            result[i] = filteredIndices[found[i]];
        }
        return result;
    }
}

