/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.matrixstatistic;

import adams.core.Range;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetView;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;

public abstract class AbstractMatrixStatistic
extends AbstractOptionHandler {
    private static final long serialVersionUID = -7187115330070305271L;
    protected Range m_Rows;
    protected SpreadSheetColumnRange m_Columns;
    protected String m_LastError;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("col", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows of the subset to retrieve.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns of the subset to retrieve; " + this.m_Columns.getExample();
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    protected String check(SpreadSheet sheet) {
        String result = null;
        if (sheet == null) {
            result = "No data provided!";
        }
        if (sheet != null) {
            this.m_Rows.setMax(sheet.getRowCount());
            this.m_Columns.setData(sheet);
            if (this.m_Rows.getIntIndices().length == 0) {
                result = "No rows selected!";
            } else if (this.m_Columns.getIntIndices().length == 0) {
                result = "No columns selected!";
            }
        }
        return result;
    }

    protected SpreadSheet createOutputHeader() {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        return result;
    }

    protected TDoubleList getNumericValues(SpreadSheet sheet) {
        TDoubleArrayList result = new TDoubleArrayList();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            for (Cell cell : row.cells()) {
                double val;
                if (cell.isMissing() || !cell.isNumeric() || Double.isNaN(val = cell.toDouble().doubleValue()) || Double.isInfinite(val)) continue;
                result.add(val);
            }
        }
        return result;
    }

    protected abstract SpreadSheet doGenerate(SpreadSheet var1);

    public SpreadSheet generate(SpreadSheet sheet) {
        SpreadSheet result = null;
        this.m_LastError = this.check(sheet);
        if (this.m_LastError == null) {
            this.m_Rows.setMax(sheet.getRowCount());
            this.m_Columns.setData(sheet);
            if (!this.m_Rows.isAllRange() || !this.m_Columns.isAllRange()) {
                sheet = new SpreadSheetView(sheet, this.m_Rows.isAllRange() ? null : this.m_Rows.getIntIndices(), this.m_Columns.isAllRange() ? null : this.m_Columns.getIntIndices());
            }
            if ((result = this.doGenerate(sheet)) == null && this.m_LastError == null) {
                this.m_LastError = "Error occurred generating statistics!";
            }
        }
        return result;
    }
}

