/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.matrixstatistic;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;

public class Min
extends AbstractMatrixStatistic {
    private static final long serialVersionUID = 330391755072250767L;

    public String globalInfo() {
        return "Determines the smallest numeric value in the matrix, skips NaN and infinite values.";
    }

    @Override
    protected SpreadSheet doGenerate(SpreadSheet sheet) {
        DataRow row;
        SpreadSheet result = this.createOutputHeader();
        double max = Double.POSITIVE_INFINITY;
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            for (Cell cell : row.cells()) {
                double val;
                if (cell.isMissing() || !cell.isNumeric() || Double.isNaN(val = cell.toDouble().doubleValue()) || Double.isInfinite(val)) continue;
                max = Math.min(max, val);
            }
        }
        row = result.addRow();
        row.addCell(0).setContent("Min");
        row.addCell(1).setContent(Double.valueOf(max));
        return result;
    }
}

