/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class JFreeChartPlot
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -2648121220428217287L;
    protected AbstractDatasetGenerator m_Dataset;
    protected AbstractChartGenerator m_Chart;
    protected JFreeChart m_JFreeChart;
    protected ChartPanel m_PlotPanel;

    public String globalInfo() {
        return "Generates and displays a plot using JFreeChart.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
        this.m_OptionManager.add("chart", "chart", (Object)new XYLineChart());
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public void setChart(AbstractChartGenerator value) {
        this.m_Chart = value;
        this.reset();
    }

    public AbstractChartGenerator getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The chart generator to use.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)", dataset: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)((Object)this.m_Chart), (String)", chart: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected void display(Token token) {
        SpreadSheet sheet = (SpreadSheet)token.getPayload();
        Object dataset = this.m_Dataset.generate(sheet);
        this.m_JFreeChart = this.m_Chart.generate(dataset);
        this.m_PlotPanel = new ChartPanel(this.m_JFreeChart);
        this.m_Panel.removeAll();
        this.m_Panel.add((Component)this.m_PlotPanel, (Object)"Center");
    }

    public void clearPanel() {
        this.m_Panel.removeAll();
        this.m_JFreeChart = null;
    }

    protected BasePanel newPanel() {
        return new BasePanel();
    }

    public JComponent supplyComponent() {
        return this.m_PlotPanel;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -3785685146120118884L;
            protected JFreeChart m_JFreeChart;
            protected ChartPanel m_PlotPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
            }

            public void display(Token token) {
                SpreadSheet sheet = (SpreadSheet)token.getPayload();
                Object dataset = JFreeChartPlot.this.m_Dataset.generate(sheet);
                this.m_JFreeChart = JFreeChartPlot.this.m_Chart.generate(dataset);
                this.m_PlotPanel = new ChartPanel(this.m_JFreeChart);
                this.removeAll();
                this.add((Component)this.m_PlotPanel, "Center");
            }

            public void clearPanel() {
                this.removeAll();
                this.m_JFreeChart = null;
            }

            public void cleanUp() {
                this.removeAll();
                this.m_JFreeChart = null;
            }

            public JComponent supplyComponent() {
                return this.m_PlotPanel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

