/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.MultiSheetSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractArrayProvider;
import java.io.File;
import java.util.List;

public class SpreadSheetFileReader
extends AbstractArrayProvider {
    private static final long serialVersionUID = -1585651878523228177L;
    protected SpreadSheetReader m_Reader;

    public String globalInfo() {
        return "Reads a spreadsheet file and forwards the content.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)this.m_Reader, (String)"reader: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)(this.m_OutputArray ? "as array" : "one-by-one"), (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected Class getItemClass() {
        if (this.m_Reader != null && this.m_Reader.getSpreadSheetType() != null) {
            return this.m_Reader.getSpreadSheetType().getClass();
        }
        return SpreadSheet.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the sheets get output as array rather than one-by-one.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader for storing the spreadsheet.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        boolean added = false;
        if (this.m_Reader instanceof MultiSheetSpreadSheetReader) {
            List sheets = ((MultiSheetSpreadSheetReader)this.m_Reader).readRange(file);
            if (sheets != null) {
                int i = 0;
                for (SpreadSheet sh : sheets) {
                    ++i;
                    if (sh.hasName()) continue;
                    sh.setName(FileUtils.replaceExtension((File)file, (String)"").getName() + "-" + i);
                }
                this.m_Queue.addAll(sheets);
                added = true;
            }
        } else if (this.m_Reader instanceof ChunkedSpreadSheetReader) {
            SpreadSheet sheet = this.m_Reader.read(file);
            if (sheet != null) {
                if (!sheet.hasName()) {
                    sheet.setName(FileUtils.replaceExtension((File)file, (String)"").getName());
                }
                this.m_OutputToken = this.m_OutputArray ? new Token((Object)new SpreadSheet[]{sheet}) : new Token((Object)sheet);
                added = true;
            }
        } else {
            SpreadSheet sheet = this.m_Reader.read(file);
            if (sheet != null) {
                this.m_Queue.add(sheet);
                added = true;
            }
        }
        if (this.isStopped()) {
            this.m_Queue.clear();
            this.m_OutputToken = null;
        } else if (!added) {
            result = this.m_Reader.hasLastError() ? "Error reading spreadsheet: " + file + "\n" + this.m_Reader.getLastError() : "Error reading spreadsheet: " + file;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        boolean result = this.m_Reader instanceof ChunkedSpreadSheetReader ? this.m_OutputToken != null | ((ChunkedSpreadSheetReader)this.m_Reader).hasMoreChunks() : super.hasPendingOutput();
        return result;
    }

    public Token output() {
        Token result = null;
        if (this.m_Reader instanceof ChunkedSpreadSheetReader) {
            if (this.m_OutputToken != null) {
                result = this.m_OutputToken;
                this.m_OutputToken = null;
            } else if (((ChunkedSpreadSheetReader)this.m_Reader).hasMoreChunks()) {
                result = this.m_OutputArray ? new Token((Object)new SpreadSheet[]{((ChunkedSpreadSheetReader)this.m_Reader).nextChunk()}) : new Token((Object)((ChunkedSpreadSheetReader)this.m_Reader).nextChunk());
            }
        } else {
            result = super.output();
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Reader != null) {
            this.m_Reader.stopExecution();
        }
        super.stopExecution();
    }
}

