/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SpreadSheetInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected SpreadSheetColumnIndex m_ColumnIndex;
    protected boolean m_Sort;

    public String globalInfo() {
        return "Outputs statistics of a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_ROWS);
        this.m_OptionManager.add("column-index", "columnIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("sort", "sort", (Object)true);
    }

    protected void initialize() {
        super.initialize();
        this.m_ColumnIndex = new SpreadSheetColumnIndex();
    }

    public String getQuickInfo() {
        String result = null;
        result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.NAME, InfoType.COMMENTS, InfoType.TIMEZONE, InfoType.LOCALE, InfoType.NUM_COLUMNS, InfoType.NUM_ROWS));
        if (!types.contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnIndex", (Object)((Object)this.m_ColumnIndex), (String)", index: ");
        }
        if ((types = new HashSet<InfoType>(Arrays.asList(InfoType.COLUMN_NAMES, InfoType.CELL_VALUES))).contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sort", (boolean)this.m_Sort, (String)(this.m_Sort ? "sorted" : "unsorted"), (String)", ");
        }
        return result;
    }

    public String outputArrayTipText() {
        return "If enabled, the info items get output as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setColumnIndex(SpreadSheetColumnIndex value) {
        this.m_ColumnIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnIndex() {
        return this.m_ColumnIndex;
    }

    public String columnIndexTipText() {
        return "The column index to use for generating column-specific information. " + this.m_ColumnIndex.getExample();
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
        this.reset();
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public String sortTipText() {
        return "If enabled, lists (eg names, values) are sorted.";
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case NAME: 
            case COMMENTS: 
            case TIMEZONE: 
            case LOCALE: 
            case COLUMN_NAME: 
            case COLUMN_NAMES: 
            case COLUMN_TYPE: 
            case CELL_TYPES: 
            case CELL_VALUES: {
                return String.class;
            }
            case NUM_COLUMNS: 
            case NUM_ROWS: {
                return Integer.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue = new ArrayList();
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ColumnIndex.setSpreadSheet(sheet);
        switch (this.m_Type) {
            case NAME: {
                this.m_Queue.add(sheet.getName());
                break;
            }
            case COMMENTS: {
                this.m_Queue.addAll(sheet.getComments());
                break;
            }
            case TIMEZONE: {
                this.m_Queue.add(sheet.getTimeZone().getID());
                break;
            }
            case LOCALE: {
                this.m_Queue.add(sheet.getLocale().toString());
                break;
            }
            case COLUMN_NAME: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                this.m_Queue.add(sheet.getHeaderRow().getCell(index).getContent());
                break;
            }
            case COLUMN_NAMES: {
                for (Cell cell : sheet.getHeaderRow().cells()) {
                    this.m_Queue.add(cell.getContent());
                }
                if (!this.m_Sort) break;
                Collections.sort(this.m_Queue);
                break;
            }
            case NUM_COLUMNS: {
                this.m_Queue.add(sheet.getColumnCount());
                break;
            }
            case NUM_ROWS: {
                this.m_Queue.add(sheet.getRowCount());
                break;
            }
            case COLUMN_TYPE: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                Cell.ContentType type = sheet.getContentType(index);
                if (type == null) {
                    type = Cell.ContentType.STRING;
                }
                this.m_Queue.add(type.toString());
                break;
            }
            case CELL_TYPES: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                Collection types = sheet.getContentTypes(index);
                for (Cell.ContentType ct : types) {
                    this.m_Queue.add(ct.toString());
                }
                break;
            }
            case CELL_VALUES: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                this.m_Queue.addAll(Arrays.asList(SpreadSheetUtils.getColumn((SpreadSheet)sheet, (int)index, (boolean)true, (boolean)this.m_Sort)));
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public static enum InfoType {
        NAME,
        COMMENTS,
        TIMEZONE,
        LOCALE,
        NUM_COLUMNS,
        NUM_ROWS,
        COLUMN_NAME,
        COLUMN_NAMES,
        COLUMN_TYPE,
        CELL_TYPES,
        CELL_VALUES;

    }
}

