/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.JTableHelper;
import adams.gui.core.SortableTableModel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.sendto.AbstractSendToAction;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ExportAsSpreadsheet
extends AbstractSendToAction {
    private static final long serialVersionUID = -5286281737195775697L;

    public String getAction() {
        return "Export as spreadsheet";
    }

    public String getIconName() {
        return "spreadsheet.png";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, SpreadSheetTable.class, SpreadSheetSupporter.class, JTable.class};
    }

    public String send(Object o) {
        String result = null;
        SpreadSheet sheet = null;
        if (o instanceof SpreadSheet) {
            sheet = (SpreadSheet)o;
        } else if (o instanceof SpreadSheetTable) {
            sheet = ((SpreadSheetTable)o).toSpreadSheet(TableRowRange.VISIBLE);
        } else if (o instanceof SpreadSheetSupporter) {
            sheet = ((SpreadSheetSupporter)o).toSpreadSheet();
        } else if (o instanceof JTable) {
            JTable table = (JTable)o;
            sheet = table.getModel() instanceof SpreadSheetTableModel ? ((SpreadSheetTableModel)table.getModel()).toSpreadSheet() : (table.getModel() instanceof SortableTableModel ? JTableHelper.toSpreadSheet((TableModel)((SortableTableModel)table.getModel()).getUnsortedModel()) : JTableHelper.toSpreadSheet((JTable)table));
        }
        if (sheet != null) {
            SpreadSheetFileChooser fileChooser = new SpreadSheetFileChooser();
            int retVal = fileChooser.showSaveDialog(null);
            if (retVal != 0) {
                result = "Export canceled by user!";
            }
            if (result == null) {
                try {
                    File file = fileChooser.getSelectedFile().getAbsoluteFile();
                    SpreadSheetWriter writer = (SpreadSheetWriter)fileChooser.getWriter();
                    if (!writer.write(sheet, file)) {
                        result = "Failed to export spreadsheet!";
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to export spreadsheet: ";
                    result = msg + e;
                    this.getLogger().log(Level.SEVERE, msg, (Throwable)e);
                }
            }
        } else {
            result = "Cannot export object as spreadsheet: " + o.getClass();
        }
        return result;
    }
}

