/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import adams.flow.transformer.plotgenerator.SimplePlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractRowBasedChartGenerator;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;

public abstract class AbstractXYChartGenerator
extends AbstractRowBasedChartGenerator {
    private static final long serialVersionUID = -3167297287561137402L;
    protected SpreadSheetColumnIndex m_XColumn;
    protected SpreadSheetColumnRange m_YColumns;
    protected AbstractColorProvider m_ColorProvider;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("y-columns", "YColumns", (Object)"");
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
    }

    protected void initialize() {
        super.initialize();
        this.m_YColumns = new SpreadSheetColumnRange();
        this.m_XColumn = new SpreadSheetColumnIndex();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"XColumn", (Object)(this.m_XColumn.isEmpty() ? "-none-" : this.m_XColumn), (String)"x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"YColumns", (Object)(this.m_YColumns.isEmpty() ? "-none-" : this.m_YColumns), (String)", y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colorProvider", (Object)this.m_ColorProvider, (String)", color: ");
        return result;
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The index of the (optional) column which values to use on the X axis; if no column provided, the row index is used instead; " + this.m_XColumn.getExample();
    }

    public void setYColumns(String value) {
        this.m_YColumns.setRange(value);
        this.reset();
    }

    public String getYColumns() {
        return this.m_YColumns.getRange();
    }

    public String YColumnsTipText() {
        return "The range of columns to use on the Y axis; " + this.m_YColumns.getExample();
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use.";
    }

    @Override
    protected void check(String name, SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("No spreadsheet supplied!");
        }
        this.m_XColumn.setData(sheet);
        this.m_YColumns.setData(sheet);
        if (this.m_YColumns.getIntIndices().length == 0) {
            throw new IllegalArgumentException("No (valid) plot columns supplied: " + this.m_YColumns.getRange());
        }
    }

    protected SpreadSheetPlotGenerator configureGenerator(SpreadSheet sheet) {
        AbstractPlotGenerator generator;
        if (this.m_XColumn.getIntIndex() == -1) {
            generator = new SimplePlotGenerator();
            ((SimplePlotGenerator)generator).setPlotColumns(this.m_YColumns.getRange());
        } else {
            generator = new XYPlotGenerator();
            ((XYPlotGenerator)generator).setXColumn(this.m_XColumn.getIndex());
            ((XYPlotGenerator)generator).setPlotColumns(this.m_YColumns.getRange());
        }
        SpreadSheetPlotGenerator result = new SpreadSheetPlotGenerator();
        result.setGenerator(generator);
        return result;
    }

    protected String getXAxisLabel(SpreadSheet sheet) {
        return this.m_XColumn.getIntIndex() == -1 ? "X" : sheet.getColumnName(this.m_XColumn.getIntIndex());
    }

    protected String getYAxisLabel(SpreadSheet sheet) {
        int[] indices = this.m_YColumns.getIntIndices();
        return indices.length == 1 ? sheet.getColumnName(indices[0]) : "Y";
    }

    protected void configureSequencePlotter(SpreadSheet sheet, SequencePlotter plotter) {
        plotter.setShortTitle(true);
        plotter.setColorProvider(this.m_ColorProvider.shallowCopy());
        plotter.setWidth(this.m_Width);
        plotter.setHeight(this.m_Height);
        SimplePlotUpdater updater = new SimplePlotUpdater();
        updater.setUpdateInterval(-1);
        plotter.setPlotUpdater((AbstractPlotUpdater)updater);
        AxisPanelOptions axis = plotter.getAxisX();
        axis.setLabel(this.getXAxisLabel(sheet));
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.columnTypeToTickGenerator(sheet, this.m_XColumn.getIntIndex()));
        axis.setType(this.columnTypeToAxisType(sheet, this.m_XColumn.getIntIndex()));
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        plotter.setAxisX(axis);
        int[] indices = this.m_YColumns.getIntIndices();
        axis = plotter.getAxisY();
        axis.setLabel(this.getYAxisLabel(sheet));
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.columnTypesToTickGenerator(sheet, indices));
        axis.setType(this.columnTypesToAxisType(sheet, indices));
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        axis.setWidth(80);
        plotter.setAxisY(axis);
    }
}

