/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToDoubleMatrix;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.rowfinder.ByIndex;
import adams.data.statistics.ArrayHistogram;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.transformer.ArrayStatistic;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetColumnFilter;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.flow.transformer.SpreadSheetRowFilter;
import adams.flow.transformer.plotgenerator.RowWisePlotGenerator;
import adams.flow.transformer.plotgenerator.SimplePlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.SimpleTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.sequence.BarPaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class Histogram
extends AbstractChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;
    protected Selection m_Selection;
    protected Range m_Rows;
    protected SpreadSheetColumnRange m_Columns;
    protected ArrayHistogram m_Histogram;
    protected AbstractColorProvider m_ColorProvider;
    protected int m_BarWidth;
    protected int m_Offset;

    public String globalInfo() {
        return "Generates histograms by plotting the X column against the Y column.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("selection", "selection", (Object)Selection.COLUMN);
        this.m_OptionManager.add("rows", "rows", (Object)"");
        this.m_OptionManager.add("columns", "columns", (Object)"");
        this.m_OptionManager.add("histogram", "histogram", (Object)new ArrayHistogram());
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("bar-width", "barWidth", (Object)10, (Number)1, null);
        this.m_OptionManager.add("offset", "offset", (Object)3, (Number)0, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Rows = new Range();
        this.m_Columns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"selection", (Object)((Object)this.m_Selection), (String)"selection: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)(this.m_Rows.isEmpty() ? "-none-" : this.m_Rows), (String)", rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)(this.m_Columns.isEmpty() ? "-none-" : this.m_Columns), (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"histogram", (Object)this.m_Histogram, (String)", histo: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colorProvider", (Object)this.m_ColorProvider, (String)", color: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"barWidth", (Object)this.m_BarWidth, (String)", bar: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"offset", (Object)this.m_Offset, (String)", offset: ");
        return result;
    }

    public void setSelection(Selection value) {
        this.m_Selection = value;
        this.reset();
    }

    public Selection getSelection() {
        return this.m_Selection;
    }

    public String selectionTipText() {
        return "The type of data to use as basis for the histogram";
    }

    public void setRows(String value) {
        this.m_Rows.setRange(value);
        this.reset();
    }

    public String getRows() {
        return this.m_Rows.getRange();
    }

    public String rowsTipText() {
        return "The range of rows to use for the histogram, if the selection is " + (Object)((Object)Selection.ROW) + "; " + this.m_Rows.getExample();
    }

    public void setColumns(String value) {
        this.m_Columns.setRange(value);
        this.reset();
    }

    public String getColumns() {
        return this.m_Columns.getRange();
    }

    public String columnsTipText() {
        return "The range of columns to use for the histogram, if selection is " + (Object)((Object)Selection.COLUMN) + "; " + this.m_Columns.getExample();
    }

    public void setHistogram(ArrayHistogram value) {
        this.m_Histogram = value;
        this.reset();
    }

    public ArrayHistogram getHistogram() {
        return this.m_Histogram;
    }

    public String histogramTipText() {
        return "The histogram setup to use.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use.";
    }

    public void setBarWidth(int value) {
        this.m_BarWidth = value;
        this.reset();
    }

    public int getBarWidth() {
        return this.m_BarWidth;
    }

    public String barWidthTipText() {
        return "The width of the bar in pixel.";
    }

    public void setOffset(int value) {
        this.m_Offset = value;
        this.reset();
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset in pixel for multiple plots.";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        int num;
        switch (this.m_Selection) {
            case COLUMN: {
                this.m_Columns.setData(sheet);
                num = this.m_Columns.getIntIndices().length;
                adams.data.spreadsheet.columnfinder.ByIndex cfinder = new adams.data.spreadsheet.columnfinder.ByIndex();
                cfinder.setColumns(this.m_Columns.getClone());
                SpreadSheetColumnFilter cfilter = new SpreadSheetColumnFilter();
                cfilter.setFinder(cfinder);
                flow.add((Actor)cfilter);
                break;
            }
            case ROW: {
                this.m_Rows.setMax(sheet.getRowCount());
                num = this.m_Rows.getIntIndices().length;
                ByIndex rfinder = new ByIndex();
                rfinder.setRows(this.m_Rows.getClone());
                SpreadSheetRowFilter rfilter = new SpreadSheetRowFilter();
                rfilter.setFinder(rfinder);
                flow.add((Actor)rfilter);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled selection: " + (Object)((Object)this.m_Selection));
            }
        }
        Convert conv = new Convert();
        conv.setConversion((Conversion)new SpreadSheetToDoubleMatrix());
        flow.add((Actor)conv);
        ArrayStatistic stats = new ArrayStatistic();
        stats.setStatistic(this.m_Histogram.shallowCopy(true));
        switch (this.m_Selection) {
            case COLUMN: {
                stats.setDataType(ArrayStatistic.DataType.COLUMN_BY_INDEX);
                break;
            }
            case ROW: {
                stats.setDataType(ArrayStatistic.DataType.ROW_BY_INDEX);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled selection: " + (Object)((Object)this.m_Selection));
            }
        }
        BaseString[] locations = new BaseString[num];
        for (int i = 0; i < num; ++i) {
            locations[i] = new BaseString("" + (i + 1));
        }
        stats.setLocations(locations);
        flow.add((Actor)stats);
        RowWisePlotGenerator rowwise = new RowWisePlotGenerator();
        rowwise.setDataColumns("first-last");
        SpreadSheetPlotGenerator pg = new SpreadSheetPlotGenerator();
        pg.setGenerator(rowwise);
        flow.add((Actor)pg);
        SimplePlotUpdater updater = new SimplePlotUpdater();
        updater.setUpdateInterval(0);
        SimplePlotGenerator generator = new SimplePlotGenerator();
        generator.setPlotColumns("first-last");
        BarPaintlet paintlet = new BarPaintlet();
        paintlet.setOffset(3);
        paintlet.setWidth(this.m_BarWidth);
        ViewDataClickAction action = new ViewDataClickAction();
        action.setHitDetector(paintlet.getHitDetector());
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Histogram");
        }
        plotter.setTitle(plotter.getName());
        plotter.setShortTitle(true);
        plotter.setPaintlet((XYSequencePaintlet)paintlet);
        plotter.setColorProvider(this.m_ColorProvider.shallowCopy());
        plotter.setPlotUpdater((AbstractPlotUpdater)updater);
        plotter.setWidth(this.m_Width);
        plotter.setHeight(this.m_Height);
        if (action != null) {
            plotter.setMouseClickAction((MouseClickAction)action);
        }
        AxisPanelOptions axis = plotter.getAxisX();
        axis.setLabel("Bin");
        axis.setNthValueToShow(2);
        axis.setTopMargin(0.05);
        axis.setBottomMargin(0.05);
        axis.setTickGenerator((TickGenerator)new SimpleTickGenerator());
        axis.setCustomFormat(new DecimalFormatString("0"));
        plotter.setAxisX(axis);
        axis = plotter.getAxisY();
        axis.setLabel("Value");
        axis.setNthValueToShow(1);
        axis.setTopMargin(0.05);
        axis.setTickGenerator((TickGenerator)new FancyTickGenerator());
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        axis.setWidth(80);
        plotter.setAxisY(axis);
        flow.add((Actor)plotter);
    }

    public static enum Selection {
        ROW,
        COLUMN;

    }
}

