/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.core.Index;
import adams.core.Range;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooserPanel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class LoadSpreadSheetDialog
extends BaseDialog {
    private static final long serialVersionUID = 3881690262061461134L;
    public static final String NO_SORTING = "-no sorting-";
    public static final String NO_ID = "-no ID-";
    protected LoadSpreadSheetDialog m_Self;
    protected SpreadSheetFileChooserPanel m_FilePanel;
    protected JButton m_ButtonReload;
    protected SpreadSheetTable m_TableData;
    protected JButton m_ButtonLoad;
    protected JButton m_ButtonClose;
    protected SearchPanel m_SearchPanel;
    protected JComboBox m_ComboBoxSorting;
    protected DefaultComboBoxModel m_ComboBoxSortingModel;
    protected JComboBox m_ComboBoxID;
    protected DefaultComboBoxModel m_ComboBoxIDModel;
    protected JList m_ListAdditionalAttributes;
    protected DefaultListModel m_ListAdditionalAttributesModel;
    protected JTextField m_TextAttributeRange;
    protected Range m_DefaultAttributeRange;
    protected SpreadSheet m_Sheet;
    protected int[] m_Indices;
    protected BaseTabbedPane m_TabbedPane;
    protected Index m_DefaultClassIndex;
    protected Index m_DefaultIDIndex;
    protected Index m_DefaultSortIndex;
    protected ChangeListener m_AcceptListener;
    protected ChangeListener m_CancelListener;

    public LoadSpreadSheetDialog(Dialog owner) {
        this(owner, "Load spreadsheet");
    }

    public LoadSpreadSheetDialog(Dialog owner, String title) {
        super(owner, title, Dialog.ModalityType.MODELESS);
    }

    public LoadSpreadSheetDialog(Frame owner) {
        this(owner, "Load dataset");
    }

    public LoadSpreadSheetDialog(Frame owner, String title) {
        super(owner, title, false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_Sheet = null;
        this.m_ComboBoxSortingModel = new DefaultComboBoxModel();
        this.m_ComboBoxSortingModel.addElement(NO_SORTING);
        this.m_ComboBoxIDModel = new DefaultComboBoxModel();
        this.m_ComboBoxIDModel.addElement(NO_ID);
        this.m_ListAdditionalAttributesModel = new DefaultListModel();
        this.m_DefaultClassIndex = new Index();
        this.m_DefaultIDIndex = new Index();
        this.m_DefaultSortIndex = new Index();
        this.m_DefaultAttributeRange = new Range("first-last");
        this.m_AcceptListener = null;
        this.m_CancelListener = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)contentPanel, "Center");
        JPanel panelAll = new JPanel(new BorderLayout(5, 5));
        contentPanel.add((Component)panelAll, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panelAll.add((Component)panel, "North");
        this.m_FilePanel = new SpreadSheetFileChooserPanel();
        this.m_FilePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.m_FilePanel.setPrefix("File");
        this.m_FilePanel.addChangeListener(e -> {
            this.m_ButtonLoad.setEnabled(this.getFilename().length() > 0);
            if (this.m_ButtonLoad.isEnabled()) {
                this.loadFile(false);
            }
            this.m_ButtonReload.setEnabled(this.m_ButtonLoad.isEnabled());
        });
        panel.add((Component)((Object)this.m_FilePanel), "Center");
        this.m_ButtonReload = new JButton(GUIHelper.getIcon((String)"refresh.gif"));
        this.m_ButtonReload.setEnabled(false);
        this.m_ButtonReload.addActionListener(e -> this.loadFile(true));
        JPanel panelAttributes = new JPanel(new BorderLayout());
        panelAttributes.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panelAttributes.add((Component)this.m_ButtonReload, "Center");
        panel.add((Component)panelAttributes, "East");
        this.m_TabbedPane = new BaseTabbedPane();
        panelAll.add((Component)this.m_TabbedPane, "Center");
        JPanel panelInstances = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Instances", (Component)panelInstances);
        this.m_TableData = new SpreadSheetTable(new SpreadSheetTableModel());
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        panel.add((Component)new BaseScrollPane((Component)this.m_TableData), "Center");
        panelInstances.add((Component)panel, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_SearchPanel.setTextColumns(15);
        this.m_SearchPanel.addSearchListener(e -> this.search());
        panel = new JPanel(new FlowLayout(0));
        panel.add((Component)this.m_SearchPanel);
        panel.setBorder(BorderFactory.createEmptyBorder());
        panelInstances.add((Component)panel, "South");
        panelAttributes = new JPanel(new BorderLayout());
        panelAttributes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TabbedPane.addTab("Attributes", (Component)panelAttributes);
        panel = new JPanel(new GridLayout(14, 1));
        panelAttributes.add((Component)panel, "North");
        this.m_ComboBoxID = new JComboBox(this.m_ComboBoxIDModel);
        this.m_ComboBoxID.setSelectedIndex(0);
        this.m_ComboBoxID.setToolTipText("The selected attribute gets used as ID for the instances, rather than the row index");
        JLabel label = new JLabel("ID");
        label.setDisplayedMnemonic('I');
        label.setLabelFor(this.m_ComboBoxID);
        panel.add(label);
        panel.add(this.m_ComboBoxID);
        this.m_TextAttributeRange = new JTextField(10);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.setToolTipText("For limiting the attributes being displayed");
        label = new JLabel("Attribute range");
        label.setDisplayedMnemonic('r');
        label.setLabelFor(this.m_TextAttributeRange);
        panel.add(label);
        panel.add(this.m_TextAttributeRange);
        this.m_ComboBoxSorting = new JComboBox(this.m_ComboBoxSortingModel);
        this.m_ComboBoxSorting.setSelectedIndex(0);
        this.m_ComboBoxSorting.setToolTipText("The attribute to sort the data on (ascending)");
        label = new JLabel("Sorting");
        label.setDisplayedMnemonic('r');
        label.setLabelFor(this.m_ComboBoxSorting);
        panel.add(label);
        panel.add(this.m_ComboBoxSorting);
        this.m_ListAdditionalAttributes = new JList(this.m_ListAdditionalAttributesModel);
        this.m_ListAdditionalAttributes.setToolTipText("Additional attribute values to store in the report");
        label = new JLabel("Attributes to store in report");
        label.setLabelFor(this.m_ListAdditionalAttributes);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panelAttributes.add((Component)panel, "Center");
        panel.add((Component)label, "North");
        panel.add((Component)new BaseScrollPane((Component)this.m_ListAdditionalAttributes), "Center");
        panelAll = new JPanel(new FlowLayout(2));
        contentPanel.add((Component)panelAll, "South");
        this.m_ButtonLoad = new JButton("OK");
        this.m_ButtonLoad.setMnemonic('O');
        this.m_ButtonLoad.setEnabled(false);
        this.m_ButtonLoad.addActionListener(e -> this.acceptSelection());
        panelAll.add(this.m_ButtonLoad);
        this.m_ButtonClose = new JButton("Cancel");
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(e -> this.close());
        panelAll.add(this.m_ButtonClose);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public int[] getAdditionalAttributes() {
        return this.m_ListAdditionalAttributes.getSelectedIndices();
    }

    public void setDefaultAttributeRange(String value) {
        this.m_DefaultAttributeRange.setRange(value);
    }

    public String getDefaultAttributeRange() {
        return this.m_DefaultAttributeRange.getRange();
    }

    public Range getCurrentAttributeRange() {
        return new Range(this.m_TextAttributeRange.getText());
    }

    public void setDefaultIDIndex(String value) {
        this.m_DefaultIDIndex.setIndex(value);
    }

    public String getDefaultIDIndex() {
        return this.m_DefaultIDIndex.getIndex();
    }

    public int getCurrentIDIndex() {
        if (this.m_ComboBoxID.getSelectedIndex() > -1) {
            return this.m_ComboBoxID.getSelectedIndex() - 1;
        }
        return -1;
    }

    public void setDefaultSortIndex(String value) {
        this.m_DefaultSortIndex.setIndex(value);
    }

    public String getDefaultSortIndex() {
        return this.m_DefaultSortIndex.getIndex();
    }

    public int getCurrentSortIndex() {
        if (this.m_ComboBoxSorting.getSelectedIndex() > -1) {
            return this.m_ComboBoxSorting.getSelectedIndex() - 1;
        }
        return -1;
    }

    public SpreadSheet getSpreadSheet() {
        SpreadSheet result = this.m_Sheet.getClone();
        if (this.m_ComboBoxSorting.getSelectedIndex() > 0) {
            result.sort(this.m_ComboBoxSorting.getSelectedIndex() - 1, true);
        }
        return result;
    }

    public int[] getIndices() {
        return this.m_Indices;
    }

    public String getFilename() {
        return ((File)this.m_FilePanel.getCurrent()).getAbsolutePath();
    }

    protected void loadFile(boolean reload) {
        int oldSortingIndex;
        int oldIDIndex;
        if (!((File)this.m_FilePanel.getCurrent()).isFile()) {
            return;
        }
        String oldID = null;
        if (reload && this.m_Sheet != null && (oldIDIndex = this.m_ComboBoxID.getSelectedIndex() - 1) > -1) {
            oldID = this.m_Sheet.getColumnName(oldIDIndex);
        }
        String oldSorting = null;
        if (reload && this.m_Sheet != null && (oldSortingIndex = this.m_ComboBoxSorting.getSelectedIndex() - 1) > -1) {
            oldSorting = this.m_Sheet.getColumnName(oldSortingIndex);
        }
        int[] oldAdditional = new int[]{};
        if (reload && this.m_Sheet != null) {
            oldAdditional = this.m_ListAdditionalAttributes.getSelectedIndices();
        }
        try {
            if (this.m_FilePanel.getReader() == null) {
                throw new IllegalStateException("Cannot determine reader for file!");
            }
            this.m_Sheet = this.m_FilePanel.getReader().read((File)this.m_FilePanel.getCurrent());
            this.m_TextAttributeRange.setToolTipText("#columns: " + this.m_Sheet.getColumnCount());
        }
        catch (Exception e) {
            this.m_TextAttributeRange.setToolTipText(null);
            this.m_Sheet = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading file '" + this.getFilename() + "' - exception:\n" + e));
        }
        if (!reload) {
            this.m_TextAttributeRange.setText(this.m_DefaultAttributeRange.getRange());
        }
        this.m_ComboBoxIDModel.removeAllElements();
        this.m_ComboBoxIDModel.addElement(NO_ID);
        this.m_ComboBoxID.setSelectedIndex(0);
        this.m_ComboBoxSortingModel.removeAllElements();
        this.m_ComboBoxSortingModel.addElement(NO_SORTING);
        this.m_ComboBoxSorting.setSelectedIndex(0);
        this.m_ListAdditionalAttributesModel.clear();
        if (this.m_Sheet != null) {
            oldIDIndex = -1;
            oldSortingIndex = -1;
            this.m_TableData.setModel((TableModel)new SpreadSheetTableModel(this.m_Sheet));
            for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                this.m_ComboBoxIDModel.addElement(i + 1 + ": " + this.m_Sheet.getColumnName(i));
                this.m_ComboBoxSortingModel.addElement(i + 1 + ": " + this.m_Sheet.getColumnName(i));
                this.m_ListAdditionalAttributesModel.addElement(i + 1 + ": " + this.m_Sheet.getColumnName(i));
                if (oldID != null && this.m_Sheet.getColumnName(i).equals(oldID)) {
                    oldIDIndex = i;
                }
                if (oldSorting == null || !this.m_Sheet.getColumnName(i).equals(oldSorting)) continue;
                oldSortingIndex = i;
            }
            if (oldIDIndex != -1) {
                this.m_ComboBoxID.setSelectedIndex(oldIDIndex + 1);
            } else if (!reload && this.m_DefaultIDIndex.hasIndex()) {
                this.m_DefaultIDIndex.setMax(this.m_Sheet.getColumnCount());
                if (this.m_DefaultIDIndex.getIntIndex() != -1) {
                    this.m_ComboBoxID.setSelectedIndex(this.m_DefaultIDIndex.getIntIndex() + 1);
                }
            }
            if (oldSortingIndex != -1) {
                this.m_ComboBoxSorting.setSelectedIndex(oldSortingIndex + 1);
            } else if (!reload && this.m_DefaultSortIndex.hasIndex()) {
                this.m_DefaultSortIndex.setMax(this.m_Sheet.getColumnCount());
                if (this.m_DefaultSortIndex.getIntIndex() != -1) {
                    this.m_ComboBoxSorting.setSelectedIndex(this.m_DefaultSortIndex.getIntIndex() + 1);
                }
            }
            this.m_ListAdditionalAttributes.setSelectedIndices(oldAdditional);
        } else {
            this.m_ButtonLoad.setEnabled(false);
        }
    }

    protected void acceptSelection() {
        int i;
        int[] indices;
        if (this.m_TableData.getSelectedRowCount() == 0) {
            indices = new int[this.m_Sheet.getRowCount()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = this.m_TableData.getSelectedRows();
        }
        this.m_Indices = new int[indices.length];
        for (i = 0; i < indices.length; ++i) {
            this.m_Indices[i] = (Integer)this.m_TableData.getValueAt(indices[i], 0) - 2;
        }
        this.setVisible(false);
        if (this.m_AcceptListener != null) {
            this.m_AcceptListener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    protected void search() {
        String search = this.m_SearchPanel.getSearchText().trim();
        if (search.length() == 0) {
            search = null;
        }
        this.m_TableData.search(search, this.m_SearchPanel.isRegularExpression());
        this.m_SearchPanel.grabFocus();
    }

    protected void close() {
        this.m_Indices = null;
        this.setVisible(false);
        if (this.m_CancelListener != null) {
            this.m_CancelListener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    protected void beforeShow() {
        super.beforeShow();
        this.m_Indices = null;
    }

    public void setCurrentDirectory(File value) {
        this.m_FilePanel.setCurrentDirectory(value);
    }

    public File getCurrentDirectory() {
        return this.m_FilePanel.getCurrentDirectory();
    }

    public void setCurrent(File value) {
        this.m_FilePanel.setCurrent(value);
        this.m_TableData.clearSelection();
        this.m_FilePanel.fireCurrentValueChanged();
    }

    public File getCurrent() {
        return (File)this.m_FilePanel.getCurrent();
    }

    public void setAcceptListener(ChangeListener l) {
        this.m_AcceptListener = l;
    }

    public ChangeListener getAcceptListener() {
        return this.m_AcceptListener;
    }

    public void setCancelListener(ChangeListener l) {
        this.m_CancelListener = l;
    }

    public ChangeListener getCancelListener() {
        return this.m_CancelListener;
    }
}

