/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.BasicDateTimeType;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.core.base.BaseRegExp;
import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.DateFormatString;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.NoHeaderSpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Reader;
import java.util.Locale;
import java.util.TimeZone;

public class SimpleCsvSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport
implements ChunkedSpreadSheetReader,
OptionHandlingLocaleSupporter,
NoHeaderSpreadSheetReader {
    private static final long serialVersionUID = 2446979875221254720L;
    protected String m_QuoteCharacter;
    protected String m_Separator;
    protected Range m_TextColumns;
    protected Range m_DateTimeColumns;
    protected DateFormatString m_DateTimeFormat;
    protected boolean m_DateTimeLenient;
    protected BasicDateTimeType m_DateTimeType;
    protected TimeZone m_TimeZone;
    protected Locale m_Locale;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected int m_ChunkSize;
    protected boolean m_Trim;
    protected CsvSpreadSheetReader m_Reader;

    public String globalInfo() {
        return "Reads CSV files.\nIt is possible to force columns to be text. In that case no intelligent parsing is attempted to determine the type of data a cell has.\nFor very large files, one can turn on chunking, which returns spreadsheet objects till all the data has been read.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.removeByProperty("dataRowType");
        this.m_OptionManager.removeByProperty("spreadSheetType");
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("quote-char", "quoteCharacter", (Object)"\"");
        this.m_OptionManager.add("separator", "separator", (Object)this.getDefaultSeparator());
        this.m_OptionManager.add("trim", "trim", (Object)false);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-columns", "dateTimeColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("datetime-lenient", "dateTimeLenient", (Object)false);
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)BasicDateTimeType.DATE_TIME);
        this.m_OptionManager.add("time-zone", "timeZone", (Object)TimeZone.getDefault(), false);
        this.m_OptionManager.add("locale", "locale", (Object)LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    protected BaseRegExp getDefaultMissingValue() {
        return new BaseRegExp("");
    }

    protected String getDefaultSeparator() {
        return ",";
    }

    public void setQuoteCharacter(String value) {
        if (value.length() == 1) {
            this.m_QuoteCharacter = value;
            this.reset();
        } else {
            this.getLogger().severe("Only one character allowed for quote character, provided: " + value);
        }
    }

    public String getQuoteCharacter() {
        return this.m_QuoteCharacter;
    }

    public String quoteCharacterTipText() {
        return "The character to use for surrounding text cells.";
    }

    public void setSeparator(String value) {
        if (Utils.unbackQuoteChars((String)value).length() == 1) {
            this.m_Separator = Utils.unbackQuoteChars((String)value);
            this.reset();
        } else {
            this.getLogger().severe("Only one character allowed (or two, in case of backquoted ones) for separator, provided: " + value);
        }
    }

    public String getSeparator() {
        return Utils.backQuoteChars((String)this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use for the columns; use '\\t' for tab.";
    }

    public void setTextColumns(Range value) {
        this.m_TextColumns = value;
        this.reset();
    }

    public Range getTextColumns() {
        return this.m_TextColumns;
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text.";
    }

    public void setDateTimeColumns(Range value) {
        this.m_DateTimeColumns = value;
        this.reset();
    }

    public Range getDateTimeColumns() {
        return this.m_DateTimeColumns;
    }

    public String dateTimeColumnsTipText() {
        return "The range of columns to treat as date/time msec.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/time msecs.";
    }

    public void setDateTimeLenient(boolean value) {
        this.m_DateTimeLenient = value;
        this.reset();
    }

    public boolean isDateTimeLenient() {
        return this.m_DateTimeLenient;
    }

    public String dateTimeLenientTipText() {
        return "Whether date/time msec parsing is lenient or not.";
    }

    public void setDateTimeType(BasicDateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public BasicDateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "How to interpret the date/time data.";
    }

    public void setTimeZone(TimeZone value) {
        this.m_TimeZone = value;
        this.reset();
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public String timeZoneTipText() {
        return "The time zone to use for interpreting dates/times; default is the system-wide defined one.";
    }

    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String localeTipText() {
        return "The locale to use for parsing the numbers.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    public void setTrim(boolean value) {
        this.m_Trim = value;
        this.reset();
    }

    public boolean getTrim() {
        return this.m_Trim;
    }

    public String trimTipText() {
        return "If enabled, the content of the cells gets trimmed before added.";
    }

    public String getFormatDescription() {
        return "Comma-separated values files (simple)";
    }

    public String[] getFormatExtensions() {
        return new CsvSpreadSheetReader().getFormatExtensions();
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new CsvSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return new CsvSpreadSheetReader().getInputType();
    }

    protected boolean supportsCompressedInput() {
        return new CsvSpreadSheetReader().supportsCompressedInput();
    }

    protected SpreadSheet doRead(Reader r) {
        this.m_Reader = new CsvSpreadSheetReader();
        this.m_Reader.setComment("#");
        this.m_Reader.setParseFormulas(false);
        this.m_Reader.setNumRowsColumnTypeDiscovery(100);
        this.m_Reader.setEncoding(this.getEncoding());
        this.m_Reader.setMissingValue(this.getMissingValue());
        this.m_Reader.setQuoteCharacter(this.getQuoteCharacter());
        this.m_Reader.setSeparator(this.getSeparator());
        this.m_Reader.setTrim(this.getTrim());
        this.m_Reader.setTextColumns(this.getTextColumns());
        this.m_Reader.setNoHeader(this.getNoHeader());
        this.m_Reader.setCustomColumnHeaders(this.getCustomColumnHeaders());
        this.m_Reader.setChunkSize(this.getChunkSize());
        this.m_Reader.setTimeZone(this.getTimeZone());
        this.m_Reader.setLocale(this.getLocale());
        this.m_Reader.setTimeColumns(new Range());
        this.m_Reader.setTimeMsecColumns(new Range());
        this.m_Reader.setDateColumns(new Range());
        this.m_Reader.setDateTimeColumns(new Range());
        this.m_Reader.setDateTimeMsecColumns(new Range());
        switch (this.m_DateTimeType) {
            case TIME: {
                this.m_Reader.setTimeColumns(this.getDateTimeColumns());
                this.m_Reader.setTimeFormat(this.getDateTimeFormat());
                this.m_Reader.setTimeLenient(this.isDateTimeLenient());
                break;
            }
            case TIME_MSEC: {
                this.m_Reader.setTimeMsecColumns(this.getDateTimeColumns());
                this.m_Reader.setTimeMsecFormat(this.getDateTimeFormat());
                this.m_Reader.setTimeMsecLenient(this.isDateTimeLenient());
                break;
            }
            case DATE: {
                this.m_Reader.setDateColumns(this.getDateTimeColumns());
                this.m_Reader.setDateFormat(this.getDateTimeFormat());
                this.m_Reader.setDateLenient(this.isDateTimeLenient());
                break;
            }
            case DATE_TIME: {
                this.m_Reader.setDateTimeColumns(this.getDateTimeColumns());
                this.m_Reader.setDateTimeFormat(this.getDateTimeFormat());
                this.m_Reader.setDateTimeLenient(this.isDateTimeLenient());
                break;
            }
            case DATE_TIME_MSEC: {
                this.m_Reader.setDateTimeMsecColumns(this.getDateTimeColumns());
                this.m_Reader.setDateTimeMsecFormat(this.getDateTimeFormat());
                this.m_Reader.setDateTimeMsecLenient(this.isDateTimeLenient());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled date/time type: " + this.m_DateTimeType);
            }
        }
        return this.m_Reader.read(r);
    }

    public boolean hasMoreChunks() {
        return this.m_Reader.hasMoreChunks();
    }

    public SpreadSheet nextChunk() {
        return this.m_Reader.nextChunk();
    }

    public boolean hasLastError() {
        return this.m_Reader != null && this.m_Reader.hasLastError();
    }

    protected void setLastError(String value) {
        super.setLastError(value);
        if (this.m_Reader != null) {
            this.m_Reader.setLastError(value);
        }
    }

    public String getLastError() {
        if (this.m_Reader != null) {
            return this.m_Reader.getLastError();
        }
        return null;
    }

    public void stopExecution() {
        if (this.m_Reader != null) {
            this.m_Reader.stopExecution();
        }
        super.stopExecution();
    }

    public boolean isStopped() {
        if (this.m_Reader != null) {
            return this.m_Reader.isStopped();
        }
        return super.isStopped();
    }
}

