/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.SimpleCsvSpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.io.output.TsvSpreadSheetWriter;

public class TsvSpreadSheetReader
extends SimpleCsvSpreadSheetReader {
    private static final long serialVersionUID = 2446979875221254720L;

    @Override
    public String globalInfo() {
        return "Reads TSV (tab-separated values) files.\nIt is possible to force columns to be text. In that case no intelligent parsing is attempted to determine the type of data a cell has.\nFor very large files, one can turn on chunking, which returns spreadsheet objects till all the data has been read.";
    }

    @Override
    protected String getDefaultSeparator() {
        return "\\t";
    }

    @Override
    public String getFormatDescription() {
        return "Tab-separated values files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"tsv", "tsv.gz"};
    }

    @Override
    public SpreadSheetWriter getCorrespondingWriter() {
        return new TsvSpreadSheetWriter();
    }
}

