/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Arrays;

public class SpreadSheetAppendComments
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 3734828865205265883L;
    protected BaseText m_Comments;
    protected boolean m_Replace;

    public String globalInfo() {
        return "Appends the comments of the spreadsheet. Complete replacement is possible as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("comments", "comments", (Object)new BaseText());
        this.m_OptionManager.add("replace", "replace", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"comments", (Object)this.m_Comments);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"replace", (boolean)this.m_Replace, (String)"replace", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setComments(BaseText value) {
        this.m_Comments = value;
        this.reset();
    }

    public BaseText getComments() {
        return this.m_Comments;
    }

    public String commentsTipText() {
        return "The comments to use.";
    }

    public void setReplace(boolean value) {
        this.m_Replace = value;
        this.reset();
    }

    public boolean getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "If enabled, any existing comments get replaced with the currently specified ones.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        if (this.m_Replace) {
            sheetNew.getComments().clear();
        }
        if (!this.m_Comments.isEmpty()) {
            String[] lines = Utils.split((String)this.m_Comments.getValue(), (String)"\n");
            sheetNew.getComments().addAll(Arrays.asList(lines));
        }
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

