/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.DateTimeMsec;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.TimeMsec;
import adams.core.option.OptionHandler;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.Iterator;

public class SpreadSheetConvertCells
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -4633161214275622241L;
    protected CellFinder m_Finder;
    protected boolean m_SkipMissing;
    protected String m_MissingReplacementValue;
    protected Cell.ContentType m_MissingReplacementType;
    protected Conversion m_Conversion;
    protected Cell m_Cell;

    public String globalInfo() {
        return "Finds cells in a spreadsheet and converts them with a conversion scheme.\nIf the conversion scheme generates a " + SpreadSheet.class.getName() + " object itself, this will get merged with the enclosing one: any additional columns get added and the content of the first row gets added to the row the converted cell belongs to.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
        this.m_OptionManager.add("skip-missing", "skipMissing", (Object)true);
        this.m_OptionManager.add("missing-replacement-value", "missingReplacementValue", (Object)"");
        this.m_OptionManager.add("missing-replacement-type", "missingReplacementType", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("conversion", "conversion", (Object)new ObjectToObject());
    }

    protected void reset() {
        super.reset();
        this.m_Cell = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)this.m_Conversion, (String)", conversion: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"skipMissing", (boolean)this.m_SkipMissing, (String)"skip missing", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The cell finder to use.";
    }

    public void setSkipMissing(boolean value) {
        this.m_SkipMissing = value;
        this.reset();
    }

    public boolean getSkipMissing() {
        return this.m_SkipMissing;
    }

    public String skipMissingTipText() {
        return "If enabled, missing cells are skipped.";
    }

    public void setMissingReplacementValue(String value) {
        this.m_MissingReplacementValue = value;
        this.reset();
    }

    public String getMissingReplacementValue() {
        return this.m_MissingReplacementValue;
    }

    public String missingReplacementValueTipText() {
        return "The string representation of the value to use for replacing missing values.";
    }

    public void setMissingReplacementType(Cell.ContentType value) {
        this.m_MissingReplacementType = value;
        this.reset();
    }

    public Cell.ContentType getMissingReplacementType() {
        return this.m_MissingReplacementType;
    }

    public String missingReplacementTypeTipText() {
        return "The data type to use for the replacement value for missing values.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to apply to the located cells.";
    }

    protected void transfer(SpreadSheet source, Cell cell) {
        if (source.getRowCount() < 1) {
            if (this.isLoggingEnabled()) {
                this.getLogger().warning("No data rows generated for cell: " + cell.getContent());
            }
            return;
        }
        SpreadSheet target = cell.getSpreadSheet();
        Row targetRow = cell.getOwner();
        HeaderRow targetHeader = target.getHeaderRow();
        DataRow sourceRow = source.getRow(0);
        HeaderRow sourceHeader = source.getHeaderRow();
        for (int i = 0; i < sourceHeader.getCellCount(); ++i) {
            Cell hc = sourceHeader.getCell(i);
            if (targetHeader.indexOfContent(hc.getContent()) == -1) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Adding column: " + hc.getContent());
                }
                target.insertColumn(target.getColumnCount(), hc.getContent());
            }
            if (sourceRow.getCell(i) != null && !sourceRow.getCell(i).isMissing()) {
                int col = targetHeader.indexOfContent(hc.getContent());
                targetRow.addCell(col).assign(sourceRow.getCell(i));
            }
            if (this.isStopped()) break;
        }
    }

    protected String convertCell(CellLocation location, SpreadSheet sheet) {
        Cell cell;
        String result = null;
        Object input = null;
        Object output = null;
        if (this.m_Cell == null) {
            this.m_Cell = sheet.newCell();
        }
        if (!sheet.hasCell(location.getRow(), location.getColumn())) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = this.m_Cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        if ((cell = sheet.getCell(location.getRow(), location.getColumn())).isMissing()) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = this.m_Cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        Class classIn = this.m_Conversion.accepts();
        Class classOut = this.m_Conversion.generates();
        if (input == null) {
            if (classIn == Double.class) {
                input = cell.toDouble();
            } else if (classIn == Integer.class) {
                input = cell.toLong().intValue();
            } else if (classIn == Long.class) {
                input = cell.toLong();
            } else if (classIn == Date.class) {
                input = cell.toDate();
            } else if (classIn == DateTime.class) {
                input = cell.toDateTime();
            } else if (classIn == DateTimeMsec.class) {
                input = cell.toDateTimeMsec();
            } else if (classIn == Time.class) {
                input = cell.toTime();
            } else if (classIn == TimeMsec.class) {
                input = cell.toTimeMsec();
            } else if (classIn == String.class) {
                input = cell.getContent();
            } else {
                result = "Don't know how to get cell value for conversion input type: " + classIn.getName();
            }
        }
        if (result == null) {
            this.m_Conversion.setInput(input);
            result = this.m_Conversion.convert();
        }
        if (result == null) {
            output = this.m_Conversion.getOutput();
            this.m_Conversion.cleanUp();
            if (classOut == Double.class) {
                cell.setContent((Double)output);
            } else if (classOut == Integer.class) {
                cell.setContent((Integer)output);
            } else if (classOut == Long.class) {
                cell.setContent((Long)output);
            } else if (classOut == Date.class) {
                cell.setContent((Date)output);
            } else if (classOut == DateTime.class) {
                cell.setContent((DateTime)output);
            } else if (classOut == DateTimeMsec.class) {
                cell.setContent((DateTimeMsec)output);
            } else if (classOut == Time.class) {
                cell.setContent((Time)output);
            } else if (classOut == TimeMsec.class) {
                cell.setContent((TimeMsec)output);
            } else if (classOut == String.class) {
                cell.setContentAsString((String)output);
            } else if (classOut == SpreadSheet.class) {
                this.transfer((SpreadSheet)output, cell);
            } else {
                result = "Don't know how to set cell value for conversion output type: " + classOut.getName();
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator<CellLocation> cells = this.m_Finder.findCells(sheetNew);
        while (cells.hasNext() && !this.isStopped()) {
            if (this.isStopped()) {
                return null;
            }
            result = this.convertCell(cells.next(), sheetNew);
            if (result == null) continue;
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        this.m_Conversion.stopExecution();
    }
}

