/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetViewCreator;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetSubset
extends AbstractSpreadSheetTransformer
implements SpreadSheetViewCreator {
    private static final long serialVersionUID = -253714973019682939L;
    protected Range m_Rows;
    protected SpreadSheetColumnRange m_Columns;
    protected boolean m_CreateView;

    public String globalInfo() {
        return "Extracts a subset of rows/columns from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("col", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("create-view", "createView", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Rows = new Range();
        this.m_Columns = new SpreadSheetColumnRange();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)"rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)"/cols: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows of the subset to retrieve.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns of the subset to retrieve; " + this.m_Columns.getExample();
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, then only a view of the subset is created.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Rows.setMax(sheet.getRowCount());
        this.m_Columns.setSpreadSheet(sheet);
        int[] rows = this.m_Rows.getIntIndices();
        int[] cols = this.m_Columns.getIntIndices();
        if (cols.length == 0) {
            result = "No columns selected!";
        } else {
            SpreadSheet subset;
            if (this.m_CreateView) {
                subset = sheet.toView(rows, cols);
            } else {
                int i;
                subset = sheet.newInstance();
                for (i = 0; i < cols.length; ++i) {
                    subset.getHeaderRow().addCell("" + (i + 1)).setContent(sheet.getHeaderRow().getCell(cols[i]).getContent());
                }
                for (int n = 0; n < rows.length; ++n) {
                    DataRow row = sheet.getRow(rows[n]);
                    DataRow subrow = subset.addRow("" + subset.getRowCount());
                    for (i = 0; i < cols.length; ++i) {
                        subrow.addCell("" + (i + 1)).setContent(row.getCell(cols[i]).getContent());
                    }
                }
            }
            this.m_OutputToken = new Token((Object)subset);
        }
        return result;
    }
}

