/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractRowBasedChartGenerator;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.axis.SimpleTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class GenericPlot
extends AbstractRowBasedChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;
    protected AbstractPlotGenerator m_Generator;
    protected XYSequencePaintlet m_Paintlet;
    protected AbstractColorProvider m_ColorProvider;
    protected TickGenerator m_XTickGenerator;
    protected TickGenerator m_YTickGenerator;

    public String globalInfo() {
        return "Flexible chart generator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new XYPlotGenerator());
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new LinePaintlet());
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("x-tick-generator", "XTickGenerator", (Object)new SimpleTickGenerator());
        this.m_OptionManager.add("y-tick-generator", "YTickGenerator", (Object)new SimpleTickGenerator());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)"generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"paintlet", (Object)this.m_Paintlet, (String)", paintlet: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colorProvider", (Object)this.m_ColorProvider, (String)", color: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"XTickGenerator", (Object)this.m_XTickGenerator, (String)", x-ticks: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"YTickGenerator", (Object)this.m_YTickGenerator, (String)", y-ticks: ");
        return result;
    }

    public void setGenerator(AbstractPlotGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractPlotGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator for producing the plot containers.";
    }

    public void setPaintlet(XYSequencePaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for the data.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use.";
    }

    public void setXTickGenerator(TickGenerator value) {
        this.m_XTickGenerator = value;
        this.reset();
    }

    public TickGenerator getXTickGenerator() {
        return this.m_XTickGenerator;
    }

    public String XTickGeneratorTipText() {
        return "The tick generator to use for the X axis.";
    }

    public void setYTickGenerator(TickGenerator value) {
        this.m_YTickGenerator = value;
        this.reset();
    }

    public TickGenerator getYTickGenerator() {
        return this.m_YTickGenerator;
    }

    public String YTickGeneratorTipText() {
        return "The tick generator to use for the Y axis.";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        super.addChartGeneration(flow, name, sheet);
        SpreadSheetPlotGenerator pg = new SpreadSheetPlotGenerator();
        pg.setGenerator(this.m_Generator);
        flow.add((Actor)pg);
        SimplePlotUpdater updater = new SimplePlotUpdater();
        updater.setUpdateInterval(0);
        ViewDataClickAction action = null;
        if (this.m_Paintlet instanceof AbstractXYSequencePaintlet) {
            action = new ViewDataClickAction();
            action.setHitDetector(((AbstractXYSequencePaintlet)this.m_Paintlet).getHitDetector());
        }
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Plot");
        }
        plotter.setTitle(plotter.getName());
        plotter.setShortTitle(true);
        plotter.setPaintlet(this.m_Paintlet);
        plotter.setColorProvider(this.m_ColorProvider.shallowCopy());
        plotter.setPlotUpdater((AbstractPlotUpdater)updater);
        plotter.setWidth(this.m_Width);
        plotter.setHeight(this.m_Height);
        if (action != null) {
            plotter.setMouseClickAction((MouseClickAction)action);
        }
        AxisPanelOptions axis = plotter.getAxisX();
        axis.setLabel("X");
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.m_XTickGenerator);
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        plotter.setAxisX(axis);
        axis = plotter.getAxisY();
        axis.setLabel("Y");
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.m_YTickGenerator);
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        axis.setWidth(80);
        plotter.setAxisY(axis);
        flow.add((Actor)plotter);
    }
}

